/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entry.EntryBlockIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PostEntryTask {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<PostEntryTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Level.RESOURCE_KEY_CODEC.fieldOf("dimension").forGetter(task -> task.dimension), (App)Codec.INT.fieldOf("x").forGetter(task -> task.x), (App)Codec.INT.fieldOf("y").forGetter(task -> task.y), (App)Codec.INT.fieldOf("z").forGetter(task -> task.z), (App)Codec.INT.fieldOf("entrySize").forGetter(task -> task.entrySize), (App)Codec.INT.fieldOf("index").forGetter(task -> task.index)).apply((Applicative)instance, (dimension, x, y, z, entrySize, index) -> {
        PostEntryTask task = new PostEntryTask((ResourceKey<Level>)dimension, (int)x, (int)y, (int)z, (int)entrySize);
        task.index = index;
        return task;
    }));
    private static final long MIN_TIME = 10L;
    private final ResourceKey<Level> dimension;
    private final int x;
    private final int y;
    private final int z;
    private final int entrySize;
    private int index;

    public PostEntryTask(ResourceKey<Level> dimension, int xCoord, int yCoord, int zCoord, int entrySize) {
        this.dimension = dimension;
        this.x = xCoord;
        this.y = yCoord;
        this.z = zCoord;
        this.entrySize = entrySize;
        this.index = 0;
    }

    public boolean onTick(MinecraftServer server) {
        ServerLevel world;
        if (this.isDone()) {
            return false;
        }
        ServerLevel serverLevel = world = this.dimension != null ? server.getLevel(this.dimension) : null;
        if (world == null) {
            LOGGER.error("Couldn't find world for dimension {} when performing post entry preparations! Cancelling task.", this.dimension);
            this.setDone();
            return true;
        }
        int preIndex = this.index;
        long time = System.currentTimeMillis() + 10L;
        int i = 0;
        for (BlockPos blockPos : EntryBlockIterator.get(this.x, this.y, this.z, this.entrySize)) {
            if (i >= this.index) {
                PostEntryTask.updateBlock(blockPos.immutable(), world);
                ++this.index;
                if (time <= System.currentTimeMillis()) {
                    LOGGER.debug("Updated {} blocks this tick.", (Object)(this.index - preIndex));
                    return this.index != preIndex;
                }
            }
            ++i;
        }
        LOGGER.info("Completed entry block updates for dimension {}.", (Object)this.dimension.location());
        this.setDone();
        return true;
    }

    public boolean isDone() {
        return this.index == -1;
    }

    private void setDone() {
        this.index = -1;
    }

    private static void updateBlock(BlockPos pos, ServerLevel level) {
        BlockState blockState = level.getBlockState(pos);
        level.getChunkSource().getLightEngine().checkBlock(pos);
        level.sendBlockUpdated(pos, blockState, blockState, 0);
        level.updateNeighborsAt(pos, blockState.getBlock());
    }
}

