/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.event;

import com.google.common.collect.ImmutableMap;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.player.PlayerIdentifier;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;

public class GristDropsEvent
extends LivingEvent
implements ICancellableEvent {
    private final UnderlingEntity underling;
    private final Map<PlayerIdentifier, Double> damageMap;
    private final GristSet originalDrops;
    private final GristType primaryType;
    private final GristType bonusType;
    private final double originalMultiplier;
    private MutableGristSet newDrops;

    public GristDropsEvent(UnderlingEntity underling, Map<PlayerIdentifier, Double> damageMap, GristSet originalDrops, GristType primaryType, GristType bonusType, double multiplier) {
        super((LivingEntity)underling);
        this.underling = underling;
        this.damageMap = ImmutableMap.copyOf(damageMap);
        this.originalDrops = originalDrops.asImmutable();
        this.primaryType = primaryType;
        this.bonusType = bonusType;
        this.originalMultiplier = multiplier;
        this.newDrops = originalDrops.mutableCopy();
    }

    public UnderlingEntity getUnderling() {
        return this.underling;
    }

    public EntityType<?> getUnderlingType() {
        return this.underling.getType();
    }

    public Map<PlayerIdentifier, Double> getDamageMap() {
        return this.damageMap;
    }

    public GristSet getOriginalDrops() {
        return this.originalDrops;
    }

    public GristType getPrimaryType() {
        return this.primaryType;
    }

    public GristType getBonusType() {
        return this.bonusType;
    }

    public double getOriginalMultiplier() {
        return this.originalMultiplier;
    }

    public MutableGristSet getNewDrops() {
        return this.newDrops;
    }

    public void setNewDrops(GristSet newDrops) {
        this.newDrops = newDrops.mutableCopy();
    }
}

