/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.event;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.effects.CreativeShockEffect;
import com.mraof.minestuck.effects.MSEffects;
import com.mraof.minestuck.entity.MSAttributes;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.entry.EntryEvent;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.HashMapModus;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.skaianet.TitleSelectionHook;
import com.mraof.minestuck.world.storage.MSExtraData;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class ServerEventHandler {
    private static boolean cachedCrit;

    @SubscribeEvent
    public static void serverStopped(ServerStoppedEvent event) {
        IdentifierHandler.clear();
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (event.hasTime()) {
            MSExtraData.get(server).executeEntryTasks(server);
        }
        if (((Boolean)MinestuckConfig.SERVER.hardMode.get()).booleanValue()) {
            EntryEvent.tick(server);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            TitleSelectionHook.cancelSelection((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCrit(CriticalHitEvent event) {
        if (!event.getEntity().level().isClientSide) {
            cachedCrit = event.isCriticalHit() && event.isVanillaCritical();
        }
    }

    public static boolean wasLastHitCrit(LivingEntity entity) {
        return entity instanceof ServerPlayer && cachedCrit;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEntityAttack(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity;
        if (event.getSource().getEntity() != null) {
            boolean injuredIsRealPlayer;
            Entity attacker = event.getSource().getEntity();
            LivingEntity injured = event.getEntity();
            boolean attackerIsRealPlayer = attacker instanceof ServerPlayer && !(attacker instanceof FakePlayer);
            boolean bl = injuredIsRealPlayer = injured instanceof ServerPlayer && !(injured instanceof FakePlayer);
            if (attackerIsRealPlayer && injured instanceof UnderlingEntity) {
                double modifier = ((ServerPlayer)attacker).getAttributeValue(MSAttributes.UNDERLING_DAMAGE_MODIFIER);
                event.setAmount((float)((double)event.getAmount() * modifier));
            } else if (injuredIsRealPlayer && attacker instanceof UnderlingEntity) {
                double modifier = ((ServerPlayer)injured).getAttributeValue(MSAttributes.UNDERLING_PROTECTION_MODIFIER);
                event.setAmount((float)((double)event.getAmount() * modifier));
            }
        }
        if ((livingEntity = event.getEntity()) instanceof UnderlingEntity) {
            UnderlingEntity underling = (UnderlingEntity)livingEntity;
            underling.onEntityDamaged(event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public static void onPlayerInjured(LivingDamageEvent.Post event) {
        ServerPlayer injuredPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && !((injuredPlayer = (ServerPlayer)livingEntity) instanceof FakePlayer)) {
            boolean isDoom = Title.isPlayerOfAspect(injuredPlayer, EnumAspect.DOOM);
            ItemStack handItem = injuredPlayer.getMainHandItem();
            float activateThreshold = injuredPlayer.getMaxHealth() / (injuredPlayer.getHealth() + 1.0f) / injuredPlayer.getMaxHealth();
            if (handItem.getItem() == MSItems.LUCERNE_HAMMER_OF_UNDYING.get()) {
                if (isDoom) {
                    activateThreshold *= 1.5f;
                }
                if ((activateThreshold += injuredPlayer.getRandom().nextFloat() * 0.9f) >= 1.0f && (double)injuredPlayer.getRandom().nextFloat() >= 0.75) {
                    injuredPlayer.level().playSound(null, injuredPlayer.getX(), injuredPlayer.getY(), injuredPlayer.getZ(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 1.4f);
                    injuredPlayer.setHealth(injuredPlayer.getHealth() + 3.0f);
                    injuredPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 450, 0));
                    if (isDoom) {
                        injuredPlayer.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 0));
                        handItem.hurtAndBreak(100, (LivingEntity)injuredPlayer, EquipmentSlot.MAINHAND);
                    } else {
                        handItem.hurtAndBreak(250, (LivingEntity)injuredPlayer, EquipmentSlot.MAINHAND);
                    }
                }
            }
            if (handItem.getItem() == MSItems.CRUEL_FATE_CRUCIBLE.get()) {
                activateThreshold = activateThreshold * 8.0f + injuredPlayer.getRandom().nextFloat() * 0.9f;
                if (isDoom && activateThreshold >= 1.0f && (double)injuredPlayer.getRandom().nextFloat() <= 0.2 || !isDoom && activateThreshold >= 1.0f && (double)injuredPlayer.getRandom().nextFloat() <= 0.05) {
                    AABB axisalignedbb = injuredPlayer.getBoundingBox().inflate(4.0, 2.0, 4.0);
                    List list = injuredPlayer.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
                    list.remove(injuredPlayer);
                    if (!list.isEmpty()) {
                        injuredPlayer.level().playSound(null, injuredPlayer.getX(), injuredPlayer.getY(), injuredPlayer.getZ(), SoundEvents.WITHER_HURT, SoundSource.PLAYERS, 0.5f, 1.6f);
                        if (isDoom) {
                            handItem.hurtAndBreak(2, (LivingEntity)injuredPlayer, EquipmentSlot.MAINHAND);
                        } else {
                            handItem.hurtAndBreak(10, (LivingEntity)injuredPlayer, EquipmentSlot.MAINHAND);
                        }
                        for (LivingEntity livingentity : list) {
                            livingentity.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        TitleSelectionHook.cancelSelection((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=false)
    public static void onServerChat(ServerChatEvent event) {
        Modus modus = CaptchaDeckHandler.getModus(event.getPlayer());
        if (modus instanceof HashMapModus) {
            HashMapModus hashMapModus = (HashMapModus)modus;
            hashMapModus.onChatMessage(event.getPlayer(), event.getMessage().getString());
        }
    }

    @SubscribeEvent
    public static void onGetItemBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().getItem() == ((Block)MSBlocks.TREATED_PLANKS.get()).asItem()) {
            event.setBurnTime(50);
        }
    }

    @SubscribeEvent
    public static void onEffectRemove(MobEffectEvent.Remove event) {
        ServerEventHandler.onEffectEnd(event.getEntity(), (MobEffect)event.getEffect().value());
    }

    @SubscribeEvent
    public static void onEffectExpire(MobEffectEvent.Expired expiryEvent) {
        ServerEventHandler.onEffectEnd(expiryEvent.getEntity(), (MobEffect)expiryEvent.getEffectInstance().getEffect().value());
    }

    private static void onEffectEnd(LivingEntity entityLiving, MobEffect effect) {
        if (entityLiving instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityLiving;
            if (effect == MSEffects.CREATIVE_SHOCK.get()) {
                CreativeShockEffect.onEffectEnd(player);
            }
        }
    }

    @SubscribeEvent
    public static void breadStaling(ItemExpireEvent event) {
        ItemEntity e = event.getEntity();
        if (e.getItem().getCount() == 1 && e.getItem().getItem() == Items.BREAD) {
            ItemEntity stalebread = new ItemEntity(e.level(), e.getX(), e.getY(), e.getZ(), new ItemStack((ItemLike)MSItems.STALE_BAGUETTE.get()));
            e.level().addFreshEntity((Entity)stalebread);
        }
    }
}

