/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.fluid;

import com.mraof.minestuck.fluid.MSFluids;
import com.mraof.minestuck.util.MSAttachments;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;

public class MSFluidType
extends FluidType {
    private final Style fluidStyle;

    public MSFluidType(FluidType.Properties properties, Style fluidStyle) {
        super(properties);
        this.fluidStyle = fluidStyle;
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        return MSFluidType.handleMovement(this, entity, movementVector, gravity);
    }

    protected static boolean handleMovement(MSFluidType fluidType, LivingEntity entity, Vec3 movementVector, double gravity) {
        Style fluidStyle = fluidType.getFluidStyle();
        gravity *= fluidStyle.yMovement;
        double initialY = entity.getY();
        boolean isSinking = entity.getDeltaMovement().y <= 0.0 && !MSFluidType.passesMovementThreshold(entity);
        entity.moveRelative(0.02f, movementVector);
        entity.move(MoverType.SELF, entity.getDeltaMovement());
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(fluidStyle.xzMovement, fluidStyle.yMovement, fluidStyle.xzMovement));
        Vec3 fallAdjustedMoveVec = entity.getFluidFallingAdjustedMovement(gravity, isSinking, entity.getDeltaMovement());
        entity.setDeltaMovement(fallAdjustedMoveVec);
        LastFluidTickData data = (LastFluidTickData)entity.getData(MSAttachments.LAST_FLUID_TICK);
        long tick = entity.level().getGameTime();
        long lastTick = Objects.requireNonNullElse(data.lastTickMap.get((Object)fluidType), 0L);
        if (!entity.isSwimming() && fluidStyle.hasSplashSound && tick != lastTick + 1L) {
            MSFluidType.splashSounds(entity, fluidStyle);
        }
        Vec3 moveVec = entity.getDeltaMovement();
        if (entity.horizontalCollision && entity.isFree(moveVec.x, moveVec.y + 0.6 - entity.getY() + initialY, moveVec.z)) {
            entity.setDeltaMovement(moveVec.x, moveVec.y, moveVec.z);
        }
        MSFluidType.swimSounds(entity, fluidStyle);
        data.lastTickMap.put(fluidType, tick);
        return true;
    }

    private static void splashSounds(LivingEntity entity, Style movementType) {
        SoundEvent splashSound = entity instanceof Player ? SoundEvents.PLAYER_SPLASH : SoundEvents.GENERIC_SPLASH;
        entity.playSound(splashSound, 0.25f, movementType.soundPitch);
    }

    static boolean passesMovementThreshold(LivingEntity entity) {
        Vec3 oldPosVec = new Vec3(entity.xOld, entity.yOld, entity.zOld);
        Vec3 newPosVec = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        return oldPosVec.distanceTo(newPosVec) >= 0.05;
    }

    private static void swimSounds(LivingEntity entity, Style movementType) {
        SoundEvent swimSound;
        SoundEvent soundEvent = swimSound = entity instanceof Player ? SoundEvents.PLAYER_SWIM : SoundEvents.GENERIC_SWIM;
        if (MSFluidType.passesMovementThreshold(entity)) {
            boolean goodSoundFrequency;
            boolean bl = goodSoundFrequency = (double)entity.getRandom().nextFloat() <= 0.35 && entity.level().getGameTime() % 10L == 0L;
            if (goodSoundFrequency) {
                entity.playSound(swimSound, 0.1f, movementType.soundPitch);
            }
        }
    }

    public Style getFluidStyle() {
        return this.fluidStyle;
    }

    public static void handleExtraFallReset(LivingEntity entity) {
        if (entity.fallDistance <= 0.0f || !entity.isInFluidType()) {
            return;
        }
        entity.fallDistance *= MSFluids.TYPE_REGISTER.getEntries().stream().map(Supplier::get).filter(arg_0 -> ((LivingEntity)entity).isInFluidType(arg_0)).map(arg_0 -> ((LivingEntity)entity).getFluidFallDistanceModifier(arg_0)).min(Float::compare).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public record Style(double xzMovement, double yMovement, float soundPitch, boolean hasSplashSound, SoundEvent ambientSound) {
        public static final Style VISCOUS = new Style(0.65, 0.8, 0.1f, false, SoundEvents.LAVA_AMBIENT);
        public static final Style PARTIALLY_VISCOUS = new Style(0.8, 0.8, 0.5f, true, SoundEvents.WATER_AMBIENT);
        public static final Style RUNNY = new Style(0.9, 0.9, 0.8f, true, SoundEvents.WATER_AMBIENT);
    }

    public static final class LastFluidTickData {
        private final Map<MSFluidType, Long> lastTickMap = new HashMap<MSFluidType, Long>();
    }
}

