/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.slot.InputSlot;
import com.mraof.minestuck.item.MSItems;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AnthvilMenu
extends AbstractContainerMenu {
    private static final int uraniumInputX = 143;
    private static final int uraniumInputY = 54;
    private static final int itemInputX = 81;
    private static final int itemInputY = 35;
    private final DataSlot fuelHolder;
    private final ContainerLevelAccess levelAccess;

    public AnthvilMenu(int windowId, Inventory playerInventory) {
        this(MSMenuTypes.ANTHVIL.get(), windowId, playerInventory, (IItemHandler)new ItemStackHandler(2), DataSlot.standalone(), ContainerLevelAccess.NULL);
    }

    public AnthvilMenu(int windowId, Inventory playerInventory, IItemHandler inventory, DataSlot fuelHolder, ContainerLevelAccess access) {
        this(MSMenuTypes.ANTHVIL.get(), windowId, playerInventory, inventory, fuelHolder, access);
    }

    public AnthvilMenu(MenuType<? extends AnthvilMenu> type, int windowId, Inventory playerInventory, IItemHandler inventory, DataSlot fuelHolder, ContainerLevelAccess access) {
        super(type, windowId);
        this.levelAccess = access;
        MachineContainerMenu.assertItemHandlerSize(inventory, 2);
        this.fuelHolder = fuelHolder;
        this.addSlot((Slot)new SlotItemHandler(inventory, 0, 81, 35));
        this.addSlot((Slot)new InputSlot(inventory, 1, 143, 54, (Item)MSItems.RAW_URANIUM.get()));
        this.addDataSlot(fuelHolder);
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem().copy();
            itemstack = itemstackOrig.copy();
            boolean result = slotNumber == 0 ? this.moveItemStackTo(itemstackOrig, 3, allSlots, false) : (slotNumber == 1 ? this.moveItemStackTo(itemstackOrig, 3, allSlots, false) : (itemstackOrig.getItem() == MSItems.RAW_URANIUM.get() ? this.moveItemStackTo(itemstackOrig, 1, 2, false) : this.moveItemStackTo(itemstackOrig, 0, 1, false)));
            if (!result) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)itemstackOrig, (ItemStack)slot.getItem())) {
                slot.set(itemstackOrig);
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return AnthvilMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)MSBlocks.ANTHVIL.get()));
    }

    public ContainerLevelAccess getPosition() {
        return this.levelAccess;
    }

    public int getFuel() {
        return this.fuelHolder.get();
    }
}

