/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.computer.editmode.DeployEntry;
import com.mraof.minestuck.computer.editmode.DeployList;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.network.editmode.AtheneumPackets;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class AtheneumMenu
extends AbstractContainerMenu {
    private final int INVENTORY_SIZE = 21;
    private final int INVENTORY_COLUMNS = 7;
    private final Player player;
    private final Container inventory = new SimpleContainer(21);
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private int scroll;

    public AtheneumMenu(int windowId, Inventory playerInventory) {
        super(MSMenuTypes.ATHENEUM.get(), windowId);
        this.player = playerInventory.player;
        this.addSlots();
        if (this.player instanceof ServerPlayer) {
            this.updateInventory();
        }
    }

    public void updateScroll(boolean scrollUp) {
        this.scroll += scrollUp ? -1 : 1;
        this.scroll = Mth.clamp((int)this.scroll, (int)0, (int)(this.items.size() / 7));
        this.sendPacket();
    }

    public boolean stillValid(Player player) {
        return player == this.player;
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot;
        ItemStack stack;
        if (slotIndex >= 21 && slotIndex < this.slots.size()) {
            Slot slot2 = (Slot)this.slots.get(slotIndex);
            ItemStack stack2 = slot2.getItem();
            slot2.set(ItemStack.EMPTY);
            return stack2;
        }
        if (slotIndex >= 0 && slotIndex < 21 && !(stack = (slot = (Slot)this.slots.get(slotIndex)).getItem()).isEmpty()) {
            for (int i = 21; i < this.slots.size(); ++i) {
                if (this.getSlot(i).hasItem()) continue;
                this.getSlot(i).set(stack);
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    private void addSlots() {
        int i;
        for (i = 0; i < 21; ++i) {
            this.addSlot(new InventorySlot(this.inventory, i, 26 + i % 7 * 18, 14 + i / 7 * 18));
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new ToolbarSlot((Container)this.player.getInventory(), i, 8 + i * 18, 74));
        }
    }

    private void updateInventory() {
        EditData editData = ServerEditHandler.getData(this.player);
        if (editData == null) {
            throw new IllegalStateException("Creating an editmode inventory menu, but the player is not in editmode");
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        SburbPlayerData playerData = editData.sburbData();
        List<DeployEntry> atheneumItems = DeployList.getItemList(this.player.getServer(), playerData, DeployList.EntryLists.ATHENEUM);
        atheneumItems.removeIf(deployEntry -> deployEntry.getCurrentCost(playerData) == null);
        for (DeployEntry atheneumItem : atheneumItems) {
            if (atheneumItem.getItemStack(playerData, this.player.level()).isEmpty()) continue;
            itemList.add(atheneumItem.getItemStack(playerData, this.player.level()));
        }
        boolean changed = false;
        if (itemList.size() != this.items.size()) {
            changed = true;
        } else {
            for (int i = 0; i < itemList.size(); ++i) {
                if (ItemStack.matches((ItemStack)((ItemStack)itemList.get(i)), (ItemStack)this.items.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.items = itemList;
            this.sendPacket();
        }
    }

    private void sendPacket() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("Can't send update packet to player! Found player object " + String.valueOf(this.player) + ".");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < 21; ++i) {
            itemList.add(this.items.size() <= i + this.scroll * 7 ? ItemStack.EMPTY : this.items.get(i + this.scroll * 7));
            this.inventory.setItem(i, itemList.get(i));
        }
        AtheneumPackets.Update packet = new AtheneumPackets.Update(this.scroll > 0, 21 + this.scroll * 7 < this.items.size(), itemList);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void receiveUpdatePacket(AtheneumPackets.Update packet) {
        if (!this.player.level().isClientSide) {
            throw new IllegalStateException("Should not receive update packet here for server-side menu");
        }
        for (int i = 0; i < packet.getInventory().size(); ++i) {
            this.inventory.setItem(i, packet.getInventory().get(i));
        }
    }

    public void clicked(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        super.clicked(pSlotId, pButton, pClickType, pPlayer);
        if (pClickType == ClickType.PICKUP && pButton == 1 && pSlotId >= 0) {
            this.setCarried(CaptchaCardItem.createPunchedCard(((Slot)this.slots.get(pSlotId)).getItem().getItem()));
        }
    }

    private static class InventorySlot
    extends ToolbarSlot {
        InventorySlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public ItemStack remove(int index) {
            return this.getItem();
        }

        public ItemStack getItem() {
            return this.container.getItem(this.index).copy();
        }

        public void set(ItemStack stack) {
        }
    }

    private static class ToolbarSlot
    extends Slot {
        ToolbarSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

