/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import com.mraof.minestuck.entity.consort.ConsortReputation;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsortMerchantInventory
implements Container {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CANT_AFFORD = "consort.cant_afford";
    private final NonNullList<ItemStack> inv = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final int[] prices = new int[9];
    private final ConsortEntity consort;

    public ConsortMerchantInventory(ConsortEntity consort, ListTag list) {
        this.consort = consort;
        for (int i = 0; i < list.size() && i < 9; ++i) {
            CompoundTag nbt = list.getCompound(i);
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)consort.registryAccess(), (CompoundTag)nbt.getCompound("item"));
            this.inv.set(i, (Object)stack);
            if (stack.isEmpty()) continue;
            this.prices[i] = nbt.getInt("price");
        }
    }

    public ConsortMerchantInventory(ConsortEntity consort, List<Pair<ItemStack, Integer>> stocks) {
        this.consort = consort;
        for (int i = 0; i < stocks.size(); ++i) {
            Pair<ItemStack, Integer> entry = stocks.get(i);
            this.inv.set(i, (Object)((ItemStack)entry.getKey()));
            this.prices[i] = (Integer)entry.getValue();
        }
    }

    public void handlePurchase(ServerPlayer player, boolean all, int index) {
        if (!player.level().isClientSide && index >= 0 && index < this.inv.size()) {
            ItemStack stack = (ItemStack)this.inv.get(index);
            if (stack.isEmpty()) {
                return;
            }
            PlayerData playerData = PlayerData.get(player).orElseThrow();
            int amountPurchased = (int)Math.min(this.prices[index] != 0 ? PlayerBoondollars.getBoondollars(playerData) / (long)this.prices[index] : Integer.MAX_VALUE, all ? (long)stack.getCount() : 1L);
            if (amountPurchased == 0) {
                player.sendSystemMessage((Component)Component.translatable((String)CANT_AFFORD));
            } else {
                PlayerBoondollars.takeBoondollars(playerData, amountPurchased * this.prices[index]);
                ConsortReputation.get(playerData).addConsortReputation(5, this.consort.getHomeDimension());
                ItemStack items = stack.split(amountPurchased);
                if (stack.isEmpty()) {
                    this.prices[index] = 0;
                    if (Arrays.stream(this.prices).sum() == 0) {
                        MSCriteriaTriggers.BUY_OUT_SHOP.get().trigger(player);
                    }
                }
                if (player.addItem(items)) {
                    player.inventoryMenu.broadcastChanges();
                } else {
                    ItemEntity entity = player.drop(items, false);
                    if (entity != null) {
                        entity.setNoPickUpDelay();
                    } else {
                        LOGGER.warn("Couldn't spawn in an item purchased from a consort: {}", (Object)items);
                    }
                }
            }
        }
    }

    public ListTag writeToNBT() {
        ListTag list = new ListTag();
        for (int i = 0; i < 9; ++i) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("price", this.prices[i]);
            nbt.put("item", ((ItemStack)this.inv.get(i)).saveOptional((HolderLookup.Provider)this.consort.registryAccess()));
            list.add((Object)nbt);
        }
        return list;
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inv) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inv.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ItemStack.EMPTY;
    }

    public void setItem(int index, ItemStack stack) {
    }

    public int getMaxStackSize() {
        return 0;
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    public void clearContent() {
        this.inv.clear();
        for (int i = 0; i < 9; ++i) {
            this.prices[i] = 0;
        }
    }

    public int[] getPrices() {
        return Arrays.copyOf(this.prices, 9);
    }

    public int calculatePrice(int price, int consortRep) {
        if (consortRep < -500) {
            return (int)Math.ceil(2 * price);
        }
        if (consortRep < -200) {
            return (int)Math.ceil(1.5 * (double)price);
        }
        if (consortRep < 400) {
            return price;
        }
        if (consortRep < 1200) {
            return (int)Math.ceil(0.9 * (double)price);
        }
        if (consortRep < 3500) {
            return (int)Math.floor(0.8 * (double)price);
        }
        if (consortRep < 8000) {
            return (int)Math.floor(0.7 * (double)price);
        }
        return (int)Math.floor(0.6 * (double)price);
    }

    public ContainerData createPricesFor(ServerPlayer player) {
        final ConsortReputation reputation = ConsortReputation.get(player);
        return new ContainerData(){

            public int get(int index) {
                return ConsortMerchantInventory.this.calculatePrice(ConsortMerchantInventory.this.prices[index], reputation.getConsortReputation(ConsortMerchantInventory.this.consort.getHomeDimension()));
            }

            public void set(int index, int value) {
                throw new UnsupportedOperationException();
            }

            public int getCount() {
                return 9;
            }
        };
    }
}

