/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.computer.editmode.DeployEntry;
import com.mraof.minestuck.computer.editmode.DeployList;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.network.editmode.EditmodeInventoryPackets;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class EditmodeMenu
extends AbstractContainerMenu {
    private final Player player;
    private final Container inventory = new SimpleContainer(14);
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private int scroll;

    public EditmodeMenu(int windowId, Inventory playerInventory) {
        super(MSMenuTypes.EDIT_MODE.get(), windowId);
        this.player = playerInventory.player;
        this.addSlots();
        if (this.player instanceof ServerPlayer) {
            this.updateInventory();
        }
    }

    public void updateScroll(boolean increase) {
        this.scroll += increase ? 1 : -1;
        this.scroll = Mth.clamp((int)this.scroll, (int)0, (int)(this.items.size() / 2 - 7));
        this.sendPacket();
    }

    public boolean stillValid(Player player) {
        return player == this.player;
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot;
        ItemStack stack;
        if (slotIndex >= 14 && slotIndex < this.slots.size()) {
            Slot slot2 = (Slot)this.slots.get(slotIndex);
            ItemStack stack2 = slot2.getItem();
            slot2.set(ItemStack.EMPTY);
            return stack2;
        }
        if (slotIndex >= 0 && slotIndex < 14 && !(stack = (slot = (Slot)this.slots.get(slotIndex)).getItem()).isEmpty()) {
            for (int i = 14; i < this.slots.size(); ++i) {
                if (this.getSlot(i).hasItem()) continue;
                this.getSlot(i).set(stack);
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    private void addSlots() {
        int i;
        for (i = 0; i < 14; ++i) {
            this.addSlot(new InventorySlot(this.inventory, i, 26 + i / 2 * 18, 16 + i % 2 * 18));
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new ToolbarSlot((Container)this.player.getInventory(), i, 8 + i * 18, 74));
        }
    }

    private void updateInventory() {
        EditData editData = ServerEditHandler.getData(this.player);
        if (editData == null) {
            throw new IllegalStateException("Creating an editmode inventory menu, but the player is not in editmode");
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        SburbPlayerData playerData = editData.sburbData();
        List<ItemStack> tools = DeployList.getEditmodeTools();
        List<DeployEntry> deployItems = DeployList.getItemList(this.player.getServer(), playerData, DeployList.EntryLists.DEPLOY);
        deployItems.removeIf(deployEntry -> deployEntry.getCurrentCost(playerData) == null);
        for (int i = 0; i < Math.max(tools.size(), deployItems.size()); ++i) {
            itemList.add(i >= tools.size() ? ItemStack.EMPTY : tools.get(i));
            itemList.add(i >= deployItems.size() ? ItemStack.EMPTY : deployItems.get(i).getItemStack(playerData, this.player.level()));
        }
        boolean changed = false;
        if (itemList.size() != this.items.size()) {
            changed = true;
        } else {
            for (int i = 0; i < itemList.size(); ++i) {
                if (ItemStack.matches((ItemStack)((ItemStack)itemList.get(i)), (ItemStack)this.items.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.items = itemList;
            this.sendPacket();
        }
    }

    private void sendPacket() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("Can't send update packet to player! Found player object " + String.valueOf(this.player) + ".");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < 14; ++i) {
            itemList.add(this.items.size() <= i + this.scroll * 2 ? ItemStack.EMPTY : this.items.get(i + this.scroll * 2));
            this.inventory.setItem(i, itemList.get(i));
        }
        EditmodeInventoryPackets.Update packet = new EditmodeInventoryPackets.Update(itemList, this.scroll > 0, this.scroll * 2 + 14 < this.items.size());
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void receiveUpdatePacket(EditmodeInventoryPackets.Update packet) {
        if (!this.player.level().isClientSide) {
            throw new IllegalStateException("Should not receive update packet here for server-side menu");
        }
        for (int i = 0; i < packet.inventory().size(); ++i) {
            this.inventory.setItem(i, packet.inventory().get(i));
        }
    }

    private static class InventorySlot
    extends ToolbarSlot {
        InventorySlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public ItemStack remove(int index) {
            return this.getItem();
        }

        public ItemStack getItem() {
            return this.container.getItem(this.index).copy();
        }

        public void set(ItemStack stack) {
        }
    }

    private static class ToolbarSlot
    extends Slot {
        ToolbarSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

