/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.components.MSItemComponents;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class GristWidgetMenu
extends MachineContainerMenu {
    private static final int gristWidgetInputX = 27;
    private static final int gristWidgetInputY = 20;

    public GristWidgetMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(MSMenuTypes.GRIST_WIDGET.get(), windowId, playerInventory, (IItemHandler)new ItemStackHandler(1), (ContainerData)new SimpleContainerData(3), ContainerLevelAccess.NULL, buffer.readBlockPos());
    }

    public GristWidgetMenu(int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, ContainerLevelAccess position, BlockPos machinePos) {
        this(MSMenuTypes.GRIST_WIDGET.get(), windowId, playerInventory, inventory, parameters, position, machinePos);
    }

    public GristWidgetMenu(MenuType<? extends GristWidgetMenu> type, int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, ContainerLevelAccess access, BlockPos machinePos) {
        super(type, windowId, parameters, access, machinePos);
        GristWidgetMenu.assertItemHandlerSize(inventory, 1);
        this.addSlot((Slot)new SlotItemHandler(this, inventory, 0, 27, 20){

            public boolean mayPlace(ItemStack stack) {
                return CaptchaCardItem.isUnpunchedCard(stack) && stack.has(MSItemComponents.CARD_STORED_ITEM);
            }
        });
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    @Override
    protected Block getValidBlock() {
        return (Block)MSBlocks.GRIST_WIDGET.get();
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack comparing = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem().copy();
            comparing = itemstackOrig.copy();
            boolean result = false;
            if (slotNumber == 0) {
                result = this.moveItemStackTo(itemstackOrig, 1, allSlots, false);
            } else if (this.getSlot(0).mayPlace(itemstackOrig)) {
                result = this.moveItemStackTo(itemstackOrig, 0, 1, false);
            }
            if (!result) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)itemstackOrig, (ItemStack)slot.getItem())) {
                slot.set(itemstackOrig);
            }
        }
        return comparing;
    }
}

