/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class MachineContainerMenu
extends AbstractContainerMenu {
    private final ContainerData parameters;
    @Deprecated
    public final BlockPos machinePos;
    protected final ContainerLevelAccess access;

    protected MachineContainerMenu(MenuType<?> type, int id, ContainerData parameters, ContainerLevelAccess access, BlockPos machinePos) {
        super(type, id);
        this.machinePos = Objects.requireNonNull(machinePos);
        this.access = Objects.requireNonNull(access);
        MachineContainerMenu.checkContainerDataCount((ContainerData)parameters, (int)3);
        this.parameters = parameters;
        this.addDataSlots(parameters);
    }

    protected abstract Block getValidBlock();

    public boolean stillValid(Player playerIn) {
        return MachineContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)playerIn, (Block)this.getValidBlock());
    }

    public void setIsLooping(boolean value) {
        this.parameters.set(2, value ? 1 : 0);
    }

    public void setShouldRun(boolean value) {
        this.parameters.set(1, value ? 1 : 0);
    }

    public int getProgress() {
        return this.parameters.get(0);
    }

    public boolean isLooping() {
        return this.parameters.get(2) != 0;
    }

    public boolean isRunning() {
        return this.parameters.get(1) != 0;
    }

    public ContainerLevelAccess getPosition() {
        return this.access;
    }

    protected static void assertItemHandlerSize(IItemHandler handler, int minSize) {
        if (handler.getSlots() < minSize) {
            throw new IllegalArgumentException("Container size " + handler.getSlots() + " is smaller than the expected " + minSize);
        }
    }
}

