/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.slot.InputSlot;
import com.mraof.minestuck.inventory.slot.OutputSlot;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MiniAlchemiterMenu
extends MachineContainerMenu {
    private static final int INPUT_X = 27;
    private static final int INPUT_Y = 20;
    private static final int OUTPUT_X = 135;
    private static final int OUTPUT_Y = 20;
    private final DataSlot wildcardHolder;

    public MiniAlchemiterMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(MSMenuTypes.MINI_ALCHEMITER.get(), windowId, playerInventory, (IItemHandler)new ItemStackHandler(2), (ContainerData)new SimpleContainerData(3), DataSlot.standalone(), ContainerLevelAccess.NULL, buffer.readBlockPos());
    }

    public MiniAlchemiterMenu(int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, DataSlot wildcardHolder, ContainerLevelAccess access, BlockPos machinePos) {
        this(MSMenuTypes.MINI_ALCHEMITER.get(), windowId, playerInventory, inventory, parameters, wildcardHolder, access, machinePos);
    }

    public MiniAlchemiterMenu(MenuType<? extends MiniAlchemiterMenu> type, int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, DataSlot wildcardHolder, ContainerLevelAccess access, BlockPos machinePos) {
        super(type, windowId, parameters, access, machinePos);
        MiniAlchemiterMenu.assertItemHandlerSize(inventory, 2);
        this.wildcardHolder = wildcardHolder;
        this.addSlot((Slot)new InputSlot(inventory, 0, 27, 20, ((Block)MSBlocks.CRUXITE_DOWEL.get()).asItem()));
        this.addSlot((Slot)new OutputSlot(inventory, 1, 135, 20));
        this.addDataSlot(wildcardHolder);
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    @Override
    protected Block getValidBlock() {
        return (Block)MSBlocks.MINI_ALCHEMITER.get();
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem().copy();
            itemstack = itemstackOrig.copy();
            boolean result = false;
            if (slotNumber <= 1) {
                result = this.moveItemStackTo(itemstackOrig, 2, allSlots, false);
            } else if (itemstackOrig.getItem() == ((Block)MSBlocks.CRUXITE_DOWEL.get()).asItem()) {
                result = this.moveItemStackTo(itemstackOrig, 0, 1, false);
            }
            if (!result) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)itemstackOrig, (ItemStack)slot.getItem())) {
                slot.set(itemstackOrig);
            }
        }
        return itemstack;
    }

    public GristType getWildcardType() {
        GristType type = (GristType)GristTypes.REGISTRY.byId(this.wildcardHolder.get());
        if (type == null) {
            type = GristTypes.BUILD.get();
        }
        return type;
    }
}

