/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.slot.InputSlot;
import com.mraof.minestuck.inventory.slot.OutputSlot;
import com.mraof.minestuck.item.MSItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MiniCruxtruderMenu
extends MachineContainerMenu {
    private static final int INPUT_X = 79;
    private static final int INPUT_Y = 57;
    private static final int OUTPUT_X = 79;
    private static final int OUTPUT_Y = 19;

    public MiniCruxtruderMenu(int windowId, Inventory inventoryPlayer, FriendlyByteBuf buffer) {
        this(MSMenuTypes.MINI_CRUXTRUDER.get(), windowId, inventoryPlayer, (IItemHandler)new ItemStackHandler(2), (ContainerData)new SimpleContainerData(3), ContainerLevelAccess.NULL, buffer.readBlockPos());
    }

    public MiniCruxtruderMenu(int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, ContainerLevelAccess access, BlockPos machinePos) {
        this(MSMenuTypes.MINI_CRUXTRUDER.get(), windowId, playerInventory, inventory, parameters, access, machinePos);
    }

    public MiniCruxtruderMenu(MenuType<? extends MiniCruxtruderMenu> type, int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, ContainerLevelAccess access, BlockPos machinePos) {
        super(type, windowId, parameters, access, machinePos);
        MiniCruxtruderMenu.assertItemHandlerSize(inventory, 2);
        this.addSlot((Slot)new InputSlot(inventory, 0, 79, 57, (Item)MSItems.RAW_CRUXITE.get()));
        this.addSlot((Slot)new OutputSlot(inventory, 1, 79, 19));
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    @Override
    protected Block getValidBlock() {
        return (Block)MSBlocks.MINI_CRUXTRUDER.get();
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem().copy();
            itemstack = itemstackOrig.copy();
            boolean result = false;
            if (slotNumber <= 1) {
                result = this.moveItemStackTo(itemstackOrig, 2, allSlots, false);
            } else if (itemstackOrig.is((Item)MSItems.RAW_CRUXITE.get())) {
                result = this.moveItemStackTo(itemstackOrig, 0, 1, false);
            }
            if (!result) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)itemstackOrig, (ItemStack)slot.getItem())) {
                slot.set(itemstackOrig);
            }
        }
        return itemstack;
    }
}

