/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.slot.InputSlot;
import com.mraof.minestuck.inventory.slot.OutputSlot;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.MSItemComponents;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class MiniPunchDesignixMenu
extends MachineContainerMenu {
    private static final int designixInputX = 44;
    private static final int designixInputY = 26;
    private static final int designixCardsX = 44;
    private static final int designixCardsY = 50;
    private static final int designixOutputX = 116;
    private static final int designixOutputY = 37;

    public MiniPunchDesignixMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(MSMenuTypes.MINI_PUNCH_DESIGNIX.get(), windowId, playerInventory, (IItemHandler)new ItemStackHandler(3), (ContainerData)new SimpleContainerData(3), ContainerLevelAccess.NULL, buffer.readBlockPos());
    }

    public MiniPunchDesignixMenu(int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, ContainerLevelAccess access, BlockPos machinePos) {
        this(MSMenuTypes.MINI_PUNCH_DESIGNIX.get(), windowId, playerInventory, inventory, parameters, access, machinePos);
    }

    public MiniPunchDesignixMenu(MenuType<? extends MiniPunchDesignixMenu> type, int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, ContainerLevelAccess access, BlockPos machinePos) {
        super(type, windowId, parameters, access, machinePos);
        MiniPunchDesignixMenu.assertItemHandlerSize(inventory, 3);
        this.addSlot((Slot)new SlotItemHandler(inventory, 0, 44, 26));
        this.addSlot((Slot)new InputSlot(inventory, 1, 44, 50, (Item)MSItems.CAPTCHA_CARD.get()));
        this.addSlot((Slot)new OutputSlot(inventory, 2, 116, 37));
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    @Override
    protected Block getValidBlock() {
        return (Block)MSBlocks.MINI_PUNCH_DESIGNIX.get();
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem().copy();
            itemstack = itemstackOrig.copy();
            boolean result = false;
            result = slotNumber <= 2 ? this.moveItemStackTo(itemstackOrig, 3, allSlots, false) : (itemstackOrig.is(MSItems.CAPTCHA_CARD) && (!itemstackOrig.has(MSItemComponents.CARD_STORED_ITEM) || itemstackOrig.has(MSItemComponents.ENCODED_ITEM)) ? this.moveItemStackTo(itemstackOrig, 1, 2, false) : this.moveItemStackTo(itemstackOrig, 0, 1, false));
            if (!result) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)itemstackOrig, (ItemStack)slot.getItem())) {
                slot.set(itemstackOrig);
            }
        }
        return itemstack;
    }
}

