/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.slot.InputSlot;
import com.mraof.minestuck.inventory.slot.OutputSlot;
import com.mraof.minestuck.item.MSItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MiniTotemLatheMenu
extends MachineContainerMenu {
    private static final int CARD_1_X = 26;
    private static final int CARD_1_Y = 25;
    private static final int CARD_2_X = 26;
    private static final int CARD_2_Y = 43;
    private static final int DOWEL_X = 62;
    private static final int DOWEL_Y = 34;
    private static final int OUTPUT_X = 134;
    private static final int OUTPUT_Y = 34;

    public MiniTotemLatheMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(MSMenuTypes.MINI_TOTEM_LATHE.get(), windowId, playerInventory, (IItemHandler)new ItemStackHandler(4), (ContainerData)new SimpleContainerData(3), ContainerLevelAccess.NULL, buffer.readBlockPos());
    }

    public MiniTotemLatheMenu(int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, ContainerLevelAccess access, BlockPos machinePos) {
        this(MSMenuTypes.MINI_TOTEM_LATHE.get(), windowId, playerInventory, inventory, parameters, access, machinePos);
    }

    public MiniTotemLatheMenu(MenuType<? extends MiniTotemLatheMenu> type, int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, ContainerLevelAccess access, BlockPos machinePos) {
        super(type, windowId, parameters, access, machinePos);
        MiniTotemLatheMenu.assertItemHandlerSize(inventory, 4);
        this.addSlot((Slot)new InputSlot(inventory, 0, 26, 25, (Item)MSItems.CAPTCHA_CARD.get()));
        this.addSlot((Slot)new InputSlot(inventory, 1, 26, 43, (Item)MSItems.CAPTCHA_CARD.get()));
        this.addSlot((Slot)new InputSlot(inventory, 2, 62, 34, (Item)MSItems.CRUXITE_DOWEL.get()));
        this.addSlot((Slot)new OutputSlot(inventory, 3, 134, 34));
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    @Override
    protected Block getValidBlock() {
        return (Block)MSBlocks.MINI_TOTEM_LATHE.get();
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem().copy();
            itemstack = itemstackOrig.copy();
            boolean result = false;
            if (slotNumber <= 3) {
                result = this.moveItemStackTo(itemstackOrig, 4, allSlots, false);
            } else if (itemstackOrig.getItem() == MSItems.CAPTCHA_CARD.get()) {
                result = this.moveItemStackTo(itemstackOrig, 0, 2, false);
            } else if (itemstackOrig.getItem() == ((Block)MSBlocks.CRUXITE_DOWEL.get()).asItem()) {
                result = this.moveItemStackTo(itemstackOrig, 2, 3, false);
            }
            if (!result) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)itemstackOrig, (ItemStack)slot.getItem())) {
                slot.set(itemstackOrig);
            }
        }
        return itemstack;
    }
}

