/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;

public class OptionalPosHolder {
    private final ContainerData intArray;

    public static OptionalPosHolder dummy(@Nullable BlockPos pos) {
        SimpleContainerData intArray = new SimpleContainerData(7);
        if (pos != null) {
            intArray.set(0, 1);
            intArray.set(1, pos.getX() >> 16);
            intArray.set(2, pos.getX() & 0xFFFF);
            intArray.set(3, pos.getY() >> 16);
            intArray.set(4, pos.getY() & 0xFFFF);
            intArray.set(5, pos.getZ() >> 16);
            intArray.set(6, pos.getZ() & 0xFFFF);
        }
        return new OptionalPosHolder((ContainerData)intArray);
    }

    public static OptionalPosHolder forPos(final Supplier<Optional<BlockPos>> getter) {
        return new OptionalPosHolder(new ContainerData(){

            public int get(int index) {
                Optional optionalPos = (Optional)getter.get();
                return optionalPos.map(pos -> switch (index) {
                    case 0 -> 1;
                    case 1 -> pos.getX() >> 16;
                    case 2 -> pos.getX() & 0xFFFF;
                    case 3 -> pos.getY() >> 16;
                    case 4 -> pos.getY() & 0xFFFF;
                    case 5 -> pos.getZ() >> 16;
                    case 6 -> pos.getZ() & 0xFFFF;
                    default -> 0;
                }).orElse(0);
            }

            public void set(int index, int value) {
                throw new UnsupportedOperationException();
            }

            public int getCount() {
                return 7;
            }
        });
    }

    private OptionalPosHolder(ContainerData intArray) {
        this.intArray = intArray;
    }

    public Optional<BlockPos> getBlockPos() {
        if (this.intArray.get(0) == 0) {
            return Optional.empty();
        }
        int x = this.intArray.get(1) << 16 | this.intArray.get(2);
        int y = this.intArray.get(3) << 16 | this.intArray.get(4);
        int z = this.intArray.get(5) << 16 | this.intArray.get(6);
        return Optional.of(new BlockPos(x, y, z));
    }

    public ContainerData getIntArray() {
        return this.intArray;
    }
}

