/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.OptionalPosHolder;
import com.mraof.minestuck.inventory.slot.InputSlot;
import com.mraof.minestuck.item.MSItems;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SendificatorMenu
extends MachineContainerMenu {
    private static final int uraniumInputX = 23;
    private static final int uraniumInputY = 51;
    private static final int itemInputX = 23;
    private static final int itemInputY = 22;
    private final DataSlot fuelHolder;
    private final OptionalPosHolder destinationHolder;

    public static Consumer<RegistryFriendlyByteBuf> makeExtraDataWriter(BlockPos position, @Nullable BlockPos destination) {
        return buffer -> {
            buffer.writeBlockPos(position);
            if (destination == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.writeBlockPos(destination);
            }
        };
    }

    public static SendificatorMenu newFromPacket(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        BlockPos dest = buffer.readBoolean() ? buffer.readBlockPos() : null;
        return new SendificatorMenu(MSMenuTypes.SENDIFICATOR.get(), windowId, playerInventory, (IItemHandler)new ItemStackHandler(2), (ContainerData)new SimpleContainerData(3), DataSlot.standalone(), OptionalPosHolder.dummy(dest), ContainerLevelAccess.NULL, pos);
    }

    public SendificatorMenu(int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, DataSlot fuelHolder, OptionalPosHolder destinationHolder, ContainerLevelAccess position, BlockPos machinePos) {
        this(MSMenuTypes.SENDIFICATOR.get(), windowId, playerInventory, inventory, parameters, fuelHolder, destinationHolder, position, machinePos);
    }

    public SendificatorMenu(MenuType<? extends SendificatorMenu> type, int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, DataSlot fuelHolder, OptionalPosHolder destinationHolder, ContainerLevelAccess position, BlockPos machinePos) {
        super(type, windowId, parameters, position, machinePos);
        SendificatorMenu.assertItemHandlerSize(inventory, 2);
        this.fuelHolder = fuelHolder;
        this.destinationHolder = destinationHolder;
        this.addSlot((Slot)new SlotItemHandler(inventory, 0, 23, 22));
        this.addSlot((Slot)new InputSlot(inventory, 1, 23, 51, (Item)MSItems.RAW_URANIUM.get()));
        this.addDataSlot(fuelHolder);
        this.addDataSlots(destinationHolder.getIntArray());
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    @Override
    protected Block getValidBlock() {
        return (Block)MSBlocks.SENDIFICATOR.get();
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem().copy();
            itemstack = itemstackOrig.copy();
            boolean result = slotNumber == 0 ? this.moveItemStackTo(itemstackOrig, 3, allSlots, false) : (slotNumber == 1 ? this.moveItemStackTo(itemstackOrig, 3, allSlots, false) : (itemstackOrig.getItem() == MSItems.RAW_URANIUM.get() ? this.moveItemStackTo(itemstackOrig, 1, 2, false) : this.moveItemStackTo(itemstackOrig, 0, 1, false)));
            if (!result) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)itemstackOrig, (ItemStack)slot.getItem())) {
                slot.set(itemstackOrig);
            }
        }
        return itemstack;
    }

    public int getFuel() {
        return this.fuelHolder.get();
    }

    public boolean hasDestination() {
        return this.destinationHolder.getBlockPos().isPresent();
    }

    @Nullable
    public BlockPos getDestination() {
        return this.destinationHolder.getBlockPos().orElse(null);
    }
}

