/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.slot.InputSlot;
import com.mraof.minestuck.inventory.slot.OutputSlot;
import com.mraof.minestuck.item.MSItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class UraniumCookerMenu
extends MachineContainerMenu {
    private static final int uraniumInputX = 38;
    private static final int uraniumInputY = 51;
    private static final int itemInputX = 38;
    private static final int itemInputY = 22;
    private static final int itemOutputX = 117;
    private static final int itemOutputY = 35;
    private final DataSlot fuelHolder;

    public UraniumCookerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(MSMenuTypes.URANIUM_COOKER.get(), windowId, playerInventory, (IItemHandler)new ItemStackHandler(3), (ContainerData)new SimpleContainerData(3), DataSlot.standalone(), ContainerLevelAccess.NULL, buffer.readBlockPos());
    }

    public UraniumCookerMenu(int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, DataSlot fuelHolder, ContainerLevelAccess access, BlockPos machinePos) {
        this(MSMenuTypes.URANIUM_COOKER.get(), windowId, playerInventory, inventory, parameters, fuelHolder, access, machinePos);
    }

    public UraniumCookerMenu(MenuType<? extends UraniumCookerMenu> type, int windowId, Inventory playerInventory, IItemHandler inventory, ContainerData parameters, DataSlot fuelHolder, ContainerLevelAccess access, BlockPos machinePos) {
        super(type, windowId, parameters, access, machinePos);
        UraniumCookerMenu.assertItemHandlerSize(inventory, 3);
        this.fuelHolder = fuelHolder;
        this.addSlot((Slot)new SlotItemHandler(inventory, 0, 38, 22));
        this.addSlot((Slot)new InputSlot(inventory, 1, 38, 51, (Item)MSItems.RAW_URANIUM.get()));
        this.addSlot((Slot)new OutputSlot(inventory, 2, 117, 35));
        this.addDataSlot(fuelHolder);
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    @Override
    protected Block getValidBlock() {
        return (Block)MSBlocks.URANIUM_COOKER.get();
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem().copy();
            itemstack = itemstackOrig.copy();
            boolean result = false;
            result = slotNumber == 0 ? this.moveItemStackTo(itemstackOrig, 3, allSlots, false) : (slotNumber == 1 ? this.moveItemStackTo(itemstackOrig, 3, allSlots, false) : (slotNumber == 2 ? (itemstackOrig.getItem() == MSItems.RAW_URANIUM.get() ? this.moveItemStackTo(itemstackOrig, 0, 1, false) : this.moveItemStackTo(itemstackOrig, 3, allSlots, false)) : (itemstackOrig.getItem() == MSItems.RAW_URANIUM.get() ? this.moveItemStackTo(itemstackOrig, 1, 2, false) : this.moveItemStackTo(itemstackOrig, 0, 1, false))));
            if (!result) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)itemstackOrig, (ItemStack)slot.getItem())) {
                slot.set(itemstackOrig);
            }
        }
        return itemstack;
    }

    public int getFuel() {
        return this.fuelHolder.get();
    }
}

