/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckMenu;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.inventory.captchalogue.ModusTypes;
import com.mraof.minestuck.inventory.captchalogue.StartingModusManager;
import com.mraof.minestuck.item.BoondollarsItem;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.CardStoredItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.util.MSAttachments;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class CaptchaDeckHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int EMPTY_SYLLADEX = -1;
    public static final int EMPTY_CARD = -2;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onPlayerDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!event.getEntity().level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
                CaptchaDeckHandler.dropSylladex(player);
            }
        }
    }

    @SubscribeEvent
    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ModusHolder modusHolder = CaptchaDeckHandler.getHolder(player);
        if (modusHolder.modus != null) {
            player.connection.send((CustomPacketPayload)CaptchaDeckPackets.ModusData.create(modusHolder.modus, (HolderLookup.Provider)player.registryAccess()));
        }
        if (modusHolder.modus == null && !modusHolder.givenModus) {
            CaptchaDeckHandler.tryGiveStartingModus(modusHolder, player);
        }
    }

    public static Modus createClientModus(ResourceLocation name) {
        ModusType type = (ModusType)ModusTypes.REGISTRY.get(name);
        return type != null ? (Modus)type.createClientSide() : null;
    }

    public static Modus createServerModus(ResourceLocation name) {
        ModusType type = (ModusType)ModusTypes.REGISTRY.get(name);
        return type != null ? (Modus)type.createServerSide() : null;
    }

    public static void launchItem(ServerPlayer player, ItemStack item) {
        if (item.is(MSItems.CAPTCHA_CARD) && !item.has(MSItemComponents.ENCODED_ITEM) && !item.has(MSItemComponents.CARD_STORED_ITEM)) {
            while (item.getCount() > 0 && CaptchaDeckHandler.getModus(player).increaseSize(player)) {
                item.shrink(1);
            }
        }
        if (item.getCount() > 0) {
            CaptchaDeckHandler.launchAnyItem((Player)player, item);
        }
    }

    public static void launchAnyItem(Player player, ItemStack item) {
        ItemEntity entity = new ItemEntity(player.level(), player.getX(), player.getY() + 1.0, player.getZ(), item);
        entity.setDeltaMovement(player.level().random.nextDouble() - 0.5, entity.getDeltaMovement().y, player.level().random.nextDouble() - 0.5);
        entity.setDefaultPickUpDelay();
        player.level().addFreshEntity((Entity)entity);
    }

    public static void useItem(ServerPlayer player) {
        CaptchaDeckMenu containerMenu;
        block8: {
            block7: {
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (!(abstractContainerMenu instanceof CaptchaDeckMenu)) break block7;
                containerMenu = (CaptchaDeckMenu)abstractContainerMenu;
                if (CaptchaDeckHandler.canPlayerUseModus(player)) break block8;
            }
            return;
        }
        ItemStack stack = containerMenu.getMenuItem();
        if (stack.isEmpty()) {
            return;
        }
        Modus modus = CaptchaDeckHandler.getModus(player);
        ModusType<?> type = ModusTypes.getTypeFromItem(stack.getItem());
        if (type != null) {
            ItemStack newItem = CaptchaDeckHandler.changeModus(player, stack, modus, type);
            containerMenu.setMenuItem(newItem);
        } else if (CaptchaCardItem.isUnpunchedCard(stack) && modus != null) {
            CaptchaDeckHandler.consumeCards(player, stack, modus);
        }
    }

    private static ItemStack changeModus(ServerPlayer player, ItemStack modusItem, @Nullable Modus oldModus, ModusType<?> newType) {
        Object newModus = newType.createServerSide();
        if (oldModus == null) {
            ModusHolder modusHolder = CaptchaDeckHandler.getHolder(player);
            ((Modus)newModus).initModus(modusItem, player, null, modusHolder.givenModus ? 0 : (Integer)MinestuckConfig.SERVER.initialModusSize.get());
        } else {
            ModusType<?> oldType = oldModus.getType();
            if (newType.equals(oldType)) {
                return modusItem;
            }
            if (((Modus)newModus).canSwitchFrom(oldModus)) {
                ((Modus)newModus).initModus(modusItem, player, oldModus.getItems(), oldModus.getSize());
            } else {
                for (ItemStack content : oldModus.getItems()) {
                    if (content.isEmpty()) continue;
                    CaptchaDeckHandler.launchAnyItem((Player)player, content);
                }
                ((Modus)newModus).initModus(modusItem, player, null, oldModus.getSize());
            }
        }
        CaptchaDeckHandler.setModus(CaptchaDeckHandler.getHolder(player), player, newModus);
        MSCriteriaTriggers.CHANGE_MODUS.get().trigger(player, (Modus)newModus);
        return oldModus == null ? ItemStack.EMPTY : oldModus.getModusItem();
    }

    private static void consumeCards(ServerPlayer player, ItemStack cards, Modus modus) {
        int i;
        ItemStack content = CardStoredItemComponent.getContainedRealItem(cards);
        int failed = 0;
        for (i = 0; i < cards.getCount(); ++i) {
            if (modus.increaseSize(player)) continue;
            ++failed;
        }
        if (!content.isEmpty()) {
            for (i = 0; i < cards.getCount() - failed; ++i) {
                ItemStack toPut = content.copy();
                if (CaptchaDeckHandler.putInModus(player, modus, toPut)) continue;
                CaptchaDeckHandler.launchItem(player, toPut);
            }
        }
        cards.setCount(failed);
        modus.checkAndResend(player);
    }

    public static void captchalogueItem(ServerPlayer player) {
        if (CaptchaDeckHandler.canPlayerUseModus(player) && CaptchaDeckHandler.hasModus(player)) {
            CaptchaDeckHandler.captchalogueItem(player, player.getMainHandItem());
        }
    }

    public static void captchalogueItemInSlot(ServerPlayer player, int slotIndex, int windowId) {
        if (!CaptchaDeckHandler.canPlayerUseModus(player) || !CaptchaDeckHandler.hasModus(player) || player.containerMenu.containerId != windowId) {
            return;
        }
        if (slotIndex < 0 || slotIndex >= player.containerMenu.slots.size()) {
            return;
        }
        Slot slot = player.containerMenu.getSlot(slotIndex);
        ItemStack stack = slot.safeTake(slot.getItem().getCount(), slot.getItem().getMaxStackSize(), (Player)player);
        if (stack.isEmpty()) {
            return;
        }
        CaptchaDeckHandler.captchalogueItem(player, stack);
        if (!stack.isEmpty()) {
            CaptchaDeckHandler.launchItem(player, stack);
        }
        player.containerMenu.broadcastChanges();
    }

    private static void captchalogueItem(ServerPlayer player, ItemStack stack) {
        Modus modus = CaptchaDeckHandler.getModus(player);
        if (stack.is(MSItems.BOONDOLLARS)) {
            PlayerBoondollars.addBoondollars(PlayerData.get(player).orElseThrow(), BoondollarsItem.getCount(stack));
            stack.shrink(1);
            return;
        }
        if (modus != null && !stack.isEmpty()) {
            if (CaptchaCardItem.isUnpunchedCard(stack) && stack.has(MSItemComponents.CARD_STORED_ITEM)) {
                CaptchaDeckHandler.handleCardCaptchalogue(player, modus, stack);
            } else {
                CaptchaDeckHandler.putInModus(player, modus, stack);
            }
            modus.checkAndResend(player);
        }
    }

    private static void handleCardCaptchalogue(ServerPlayer player, Modus modus, ItemStack card) {
        ItemStack stackInCard = CardStoredItemComponent.getContainedRealItem(card);
        boolean spentCard = modus.increaseSize(player);
        if (spentCard) {
            card.shrink(1);
        }
        if (!stackInCard.isEmpty()) {
            boolean captchaloguedItem = CaptchaDeckHandler.putInModus(player, modus, stackInCard);
            if (captchaloguedItem && !spentCard) {
                CaptchaDeckHandler.launchAnyItem((Player)player, new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get(), 1));
                card.shrink(1);
            } else if (!captchaloguedItem && spentCard) {
                CaptchaDeckHandler.launchAnyItem((Player)player, stackInCard);
            }
        }
    }

    private static boolean putInModus(ServerPlayer player, Modus modus, ItemStack stack) {
        boolean result = modus.putItemStack(player, stack.copy());
        if (result) {
            MSCriteriaTriggers.CAPTCHALOGUE.get().trigger(player, modus, stack);
            stack.setCount(0);
        }
        return result;
    }

    public static void getItem(ServerPlayer player, int index, boolean asCard) {
        if (!CaptchaDeckHandler.canPlayerUseModus(player)) {
            return;
        }
        Modus modus = CaptchaDeckHandler.getModus(player);
        if (modus == null) {
            return;
        }
        ItemStack stack = modus.getItem(player, index, asCard);
        if (!stack.isEmpty()) {
            ItemStack otherStack = player.getMainHandItem();
            if (otherStack.isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            } else if (CaptchaDeckHandler.canMergeItemStacks(stack, otherStack)) {
                otherStack.grow(stack.getCount());
                stack.setCount(0);
            } else {
                boolean placed = false;
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    otherStack = (ItemStack)player.getInventory().items.get(i);
                    if (otherStack.isEmpty()) {
                        player.getInventory().items.set(i, (Object)stack.copy());
                    } else {
                        if (!CaptchaDeckHandler.canMergeItemStacks(stack, otherStack)) continue;
                        otherStack.grow(stack.getCount());
                    }
                    stack.setCount(0);
                    placed = true;
                    player.getInventory().setChanged();
                    player.inventoryMenu.broadcastChanges();
                    break;
                }
                if (!placed) {
                    CaptchaDeckHandler.launchAnyItem((Player)player, stack);
                }
            }
        }
        modus.checkAndResend(player);
    }

    private static void dropSylladex(ServerPlayer player) {
        Modus modus = CaptchaDeckHandler.getModus(player);
        if (modus == null) {
            return;
        }
        NonNullList<ItemStack> stacks = modus.getItems();
        int size = modus.getSize();
        int cardsToKeep = switch ((MinestuckConfig.DropMode)((Object)MinestuckConfig.SERVER.sylladexDropMode.get())) {
            default -> throw new MatchException(null, null);
            case MinestuckConfig.DropMode.ITEMS -> size;
            case MinestuckConfig.DropMode.CARDS_AND_ITEMS -> (Integer)MinestuckConfig.SERVER.initialModusSize.get();
            case MinestuckConfig.DropMode.ALL -> 0;
        };
        for (ItemStack stack : stacks) {
            if (stack.isEmpty() || EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            if (size > cardsToKeep && ((Boolean)MinestuckConfig.SERVER.dropItemsInCards.get()).booleanValue()) {
                ItemStack card = CaptchaCardItem.createCardWithItem(stack, player.server);
                player.drop(card, true, false);
                --size;
                continue;
            }
            player.drop(stack, true, false);
        }
        int stackLimit = new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get()).getMaxStackSize();
        while (size > cardsToKeep) {
            player.drop(new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get(), Math.min(stackLimit, size - cardsToKeep)), true, false);
            size = Math.max(size - stackLimit, cardsToKeep);
        }
        if (MinestuckConfig.SERVER.sylladexDropMode.get() == MinestuckConfig.DropMode.ALL) {
            player.drop(modus.getModusItem(), true, false);
            CaptchaDeckHandler.setModus(CaptchaDeckHandler.getHolder(player), player, null);
        } else {
            modus.initModus(null, player, null, size);
            player.connection.send((CustomPacketPayload)CaptchaDeckPackets.ModusData.create(modus, (HolderLookup.Provider)player.registryAccess()));
        }
    }

    @Nullable
    public static CompoundTag writeToNBT(@Nullable Modus modus, HolderLookup.Provider provider) {
        if (modus == null) {
            return null;
        }
        ResourceLocation name = ModusTypes.REGISTRY.getKey(modus.getType());
        if (name != null) {
            CompoundTag nbt = modus.writeToNBT(new CompoundTag(), provider);
            nbt.putString("type", name.toString());
            return nbt;
        }
        return null;
    }

    public static Modus readFromNBT(CompoundTag nbt, LogicalSide side, HolderLookup.Provider provider) {
        Modus modus;
        if (nbt == null) {
            return null;
        }
        ResourceLocation name = ResourceLocation.parse((String)nbt.getString("type"));
        if (side.isClient() && ClientPlayerData.getModus() != null && name.equals((Object)ModusTypes.REGISTRY.getKey(ClientPlayerData.getModus().getType()))) {
            modus = ClientPlayerData.getModus();
        } else {
            Modus modus2 = modus = side.isClient() ? CaptchaDeckHandler.createClientModus(name) : CaptchaDeckHandler.createServerModus(name);
            if (modus == null) {
                LOGGER.warn("Failed to load modus from nbt with the name \"{}\"", (Object)name.toString());
                return null;
            }
        }
        modus.readFromNBT(nbt, provider);
        return modus;
    }

    private static boolean hasModus(ServerPlayer player) {
        return CaptchaDeckHandler.getModus(player) != null;
    }

    @Nullable
    public static Modus getModus(ServerPlayer player) {
        Optional<PlayerData> playerData = PlayerData.get(player);
        if (playerData.isEmpty()) {
            return null;
        }
        return ((ModusHolder)playerData.get().getData(MSAttachments.MODUS_HOLDER)).modus;
    }

    private static boolean canMergeItemStacks(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2) && stack1.isStackable() && stack1.getCount() + stack2.getCount() < stack1.getMaxStackSize();
    }

    private static boolean canPlayerUseModus(ServerPlayer player) {
        return !player.isSpectator() && !ServerEditHandler.isInEditmode(player);
    }

    private static void setModus(ModusHolder modusHolder, ServerPlayer player, @Nullable Modus modus) {
        if (modusHolder.modus == modus) {
            return;
        }
        modusHolder.modus = modus;
        if (modus != null) {
            modusHolder.givenModus = true;
        }
        player.connection.send((CustomPacketPayload)CaptchaDeckPackets.ModusData.create(modus, (HolderLookup.Provider)player.registryAccess()));
    }

    private static void tryGiveStartingModus(ModusHolder modusHolder, ServerPlayer player) {
        List<ModusType<?>> startingTypes = StartingModusManager.getStartingModusTypes();
        if (startingTypes.isEmpty()) {
            return;
        }
        ModusType<?> type = startingTypes.get(player.level().random.nextInt(startingTypes.size()));
        if (type == null) {
            modusHolder.givenModus = true;
            return;
        }
        Object modus = type.createServerSide();
        if (modus == null) {
            LOGGER.warn("Couldn't create a starting modus type {}.", (Object)ModusTypes.REGISTRY.getKey(type));
            return;
        }
        ((Modus)modus).initModus(null, player, null, (Integer)MinestuckConfig.SERVER.initialModusSize.get());
        CaptchaDeckHandler.setModus(modusHolder, player, modus);
    }

    private static ModusHolder getHolder(ServerPlayer player) {
        PlayerData data = PlayerData.get(player).orElseThrow();
        return (ModusHolder)data.getData(MSAttachments.MODUS_HOLDER);
    }

    public static class ModusHolder
    implements INBTSerializable<CompoundTag> {
        private boolean givenModus = false;
        @Nullable
        private Modus modus = null;

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            CompoundTag modusTag = CaptchaDeckHandler.writeToNBT(this.modus, provider);
            if (modusTag != null) {
                nbt.put("modus", (Tag)modusTag);
            } else {
                nbt.putBoolean("given_modus", this.givenModus);
            }
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            if (nbt.contains("modus")) {
                this.modus = CaptchaDeckHandler.readFromNBT(nbt.getCompound("modus"), LogicalSide.SERVER, provider);
                this.givenModus = true;
            } else {
                this.givenModus = nbt.getBoolean("given_modus");
            }
        }
    }
}

