/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.captchalogue.ModusTypes;
import com.mraof.minestuck.item.CaptchaCardItem;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CaptchaDeckMenu
extends AbstractContainerMenu {
    private final Container inventory = new SimpleContainer(1);
    private final Player owner;

    public CaptchaDeckMenu(int windowId, Inventory playerInventory) {
        super(MSMenuTypes.CAPTCHA_DECK.get(), windowId);
        this.owner = playerInventory.player;
        this.addSlots(playerInventory);
    }

    public ItemStack getMenuItem() {
        return this.inventory.getItem(0);
    }

    public void setMenuItem(ItemStack stack) {
        this.inventory.setItem(0, stack);
    }

    private void addSlots(Inventory playerInventory) {
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 9, 63, playerInventory);
        this.addSlot(new Slot(this, this.inventory, 0, 81, 32){

            public boolean mayPlace(ItemStack stack) {
                return ModusTypes.getTypeFromItem(stack.getItem()) != null || CaptchaCardItem.isUnpunchedCard(stack);
            }
        });
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        ItemStack stack = this.inventory.removeItemNoUpdate(0);
        if (!stack.isEmpty()) {
            playerIn.drop(stack, false);
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.owner == playerIn;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = this.getSlot(index);
        int slotCount = this.slots.size();
        if (slot.hasItem()) {
            ItemStack stack1 = slot.getItem().copy();
            ItemStack stack2 = stack1.copy();
            if (index == slotCount - 1 ? !this.moveItemStackTo(stack1, 0, slotCount - 1, false) : !this.getSlot(slotCount - 1).mayPlace(stack1) || !this.moveItemStackTo(stack1, slotCount - 1, slotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.matches((ItemStack)stack1, (ItemStack)slot.getItem())) {
                slot.set(stack1);
            }
            return stack2;
        }
        return ItemStack.EMPTY;
    }
}

