/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;

public class HashMapModus
extends Modus {
    public static final String MESSAGE = "minestuck.hash_map";
    protected NonNullList<ItemStack> list;
    public boolean ejectByChat = true;
    protected boolean changed;
    protected NonNullList<ItemStack> items;

    public HashMapModus(ModusType<? extends HashMapModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public void initModus(ItemStack modusItem, ServerPlayer player, NonNullList<ItemStack> prev, int size) {
        this.list = NonNullList.create();
        if (prev != null) {
            this.list.addAll(prev);
        }
        while (this.list.size() < size) {
            this.list.add((Object)ItemStack.EMPTY);
        }
        if (this.side == LogicalSide.CLIENT) {
            this.items = NonNullList.create();
            this.changed = true;
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        int size = nbt.getInt("size");
        this.ejectByChat = nbt.getBoolean("ejectByChat");
        this.list = NonNullList.create();
        for (int i = 0; i < size; ++i) {
            if (nbt.contains("item" + i, 10)) {
                this.list.add((Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound("item" + i)).orElseThrow()));
                continue;
            }
            this.list.add((Object)ItemStack.EMPTY);
        }
        if (this.side == LogicalSide.CLIENT) {
            if (this.items == null) {
                this.items = NonNullList.create();
            }
            this.changed = true;
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("size", this.list.size());
        nbt.putBoolean("ejectByChat", this.ejectByChat);
        Iterator iterator = this.list.iterator();
        for (int i = 0; i < this.list.size(); ++i) {
            ItemStack stack = (ItemStack)iterator.next();
            if (stack.isEmpty()) continue;
            nbt.put("item" + i, stack.save(provider));
        }
        return nbt;
    }

    @Override
    public boolean putItemStack(ServerPlayer player, ItemStack item) {
        if (this.list.size() == 0 || item.isEmpty()) {
            return false;
        }
        String itemName = BuiltInRegistries.ITEM.getKey((Object)item.getItem()).getPath().replace('_', ' ');
        Component customName = (Component)item.get(DataComponents.CUSTOM_NAME);
        int index = (customName != null ? customName.getString() : itemName).hashCode() % this.list.size();
        if (index < 0) {
            index += this.list.size();
        }
        if (!((ItemStack)this.list.get(index)).isEmpty()) {
            ItemStack otherItem = (ItemStack)this.list.get(index);
            if (ItemStack.isSameItemSameComponents((ItemStack)otherItem, (ItemStack)item) && otherItem.getCount() + item.getCount() <= otherItem.getMaxStackSize()) {
                otherItem.grow(item.getCount());
                this.markDirty();
                return true;
            }
            CaptchaDeckHandler.launchItem(player, (ItemStack)this.list.get(index));
        }
        this.list.set(index, (Object)item);
        this.markDirty();
        if (this.ejectByChat && MinestuckConfig.SERVER.hashmapChatModusSetting.get() != MinestuckConfig.AvailableOptions.OFF || MinestuckConfig.SERVER.hashmapChatModusSetting.get() == MinestuckConfig.AvailableOptions.ON) {
            player.sendSystemMessage((Component)Component.translatable((String)MESSAGE, (Object[])new Object[]{item.getDisplayName(), this.getSize(), index}));
        }
        return true;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        if (this.side == LogicalSide.SERVER) {
            NonNullList items = NonNullList.create();
            this.fillList((NonNullList<ItemStack>)items);
            return items;
        }
        if (this.changed) {
            this.fillList(this.items);
        }
        return this.items;
    }

    private void fillList(NonNullList<ItemStack> items) {
        items.clear();
        items.addAll(this.list);
    }

    @Override
    public boolean increaseSize(ServerPlayer player) {
        if ((Integer)MinestuckConfig.SERVER.modusMaxSize.get() > 0 && this.list.size() >= (Integer)MinestuckConfig.SERVER.modusMaxSize.get()) {
            return false;
        }
        this.list.add((Object)ItemStack.EMPTY);
        this.markDirty();
        return true;
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (((ItemStack)this.list.get(i)).isEmpty()) continue;
                CaptchaDeckHandler.launchAnyItem((Player)player, (ItemStack)this.list.get(i));
                this.list.set(i, (Object)ItemStack.EMPTY);
                this.markDirty();
            }
            return ItemStack.EMPTY;
        }
        ItemStack item = (ItemStack)this.list.get(id %= this.list.size());
        if (asCard) {
            this.list.remove(id);
            this.markDirty();
            if (item.isEmpty()) {
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return CaptchaCardItem.createCardWithItem(item, player.server);
        }
        this.list.set(id, (Object)ItemStack.EMPTY);
        this.markDirty();
        return item;
    }

    @Override
    public boolean canSwitchFrom(Modus modus) {
        return false;
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public void setValue(ServerPlayer player, byte type, int value) {
        if (this.ejectByChat != value > 0) {
            this.ejectByChat = value > 0;
            this.markDirty();
        }
    }

    public void onChatMessage(ServerPlayer player, String str) {
        if (!this.ejectByChat && MinestuckConfig.SERVER.hashmapChatModusSetting.get() != MinestuckConfig.AvailableOptions.ON || MinestuckConfig.SERVER.hashmapChatModusSetting.get() == MinestuckConfig.AvailableOptions.OFF) {
            return;
        }
        boolean isPrevLetter = false;
        StringBuilder number = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLetter(c)) {
                isPrevLetter = true;
            } else {
                if (Character.isDigit(c) || number.length() == 0 && c == '-') {
                    if (isPrevLetter) continue;
                    number.append(c);
                    continue;
                }
                isPrevLetter = false;
                if (number.length() > 0) {
                    this.handleNumber(player, number.toString());
                }
            }
            number = new StringBuilder();
        }
        if (number.length() > 0) {
            this.handleNumber(player, number.toString());
        }
        this.checkAndResend(player);
    }

    private void handleNumber(ServerPlayer player, String str) {
        ItemStack stack;
        int i;
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return;
        }
        int index = i % this.getSize();
        if (index < 0) {
            index += this.getSize();
        }
        if ((stack = this.getItem(player, index, false)) == null) {
            return;
        }
        if (player.getInventory().getSelected().isEmpty()) {
            player.getInventory().setItem(player.getInventory().selected, stack);
        } else {
            CaptchaDeckHandler.launchAnyItem((Player)player, stack);
        }
        player.sendSystemMessage((Component)Component.translatable((String)MESSAGE, (Object[])new Object[]{i, this.getSize(), index, stack.getDisplayName()}));
    }
}

