/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class Modus {
    private final ModusType<?> type;
    public final LogicalSide side;
    private boolean needResend;

    public Modus(ModusType<?> type, LogicalSide side) {
        this.type = Objects.requireNonNull(type);
        this.side = Objects.requireNonNull(side);
    }

    public abstract void initModus(ItemStack var1, ServerPlayer var2, NonNullList<ItemStack> var3, int var4);

    public abstract void readFromNBT(CompoundTag var1, HolderLookup.Provider var2);

    public abstract CompoundTag writeToNBT(CompoundTag var1, HolderLookup.Provider var2);

    public abstract boolean putItemStack(ServerPlayer var1, ItemStack var2);

    public abstract NonNullList<ItemStack> getItems();

    public int getNonEmptyCards() {
        int count = 0;
        for (ItemStack stack : this.getItems()) {
            if (stack.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public abstract boolean increaseSize(ServerPlayer var1);

    public abstract ItemStack getItem(ServerPlayer var1, int var2, boolean var3);

    public abstract boolean canSwitchFrom(Modus var1);

    public abstract int getSize();

    public void setValue(ServerPlayer player, byte type, int value) {
    }

    public ModusType<?> getType() {
        return this.type;
    }

    public ItemStack getModusItem() {
        return new ItemStack((ItemLike)this.getType().getItem());
    }

    public Component getName() {
        return new ItemStack((ItemLike)this.type.getItem()).getHoverName();
    }

    public void markDirty() {
        this.needResend = true;
    }

    public final void checkAndResend(ServerPlayer player) {
        if (this.needResend) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)CaptchaDeckPackets.ModusData.create(this, (HolderLookup.Provider)player.registryAccess()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.needResend = false;
        }
    }
}

