/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.inventory.captchalogue.StackModus;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.MSItemComponents;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;

public class QueueModus
extends StackModus {
    public QueueModus(ModusType<? extends QueueModus> type, LogicalSide side) {
        super((ModusType<? extends StackModus>)type, side);
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (ItemStack item : this.list) {
                CaptchaDeckHandler.launchAnyItem((Player)player, item);
            }
            this.list.clear();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        ItemStack item = (ItemStack)this.list.removeLast();
        this.markDirty();
        if (!(!asCard || CaptchaCardItem.isUnpunchedCard(item) && item.has(MSItemComponents.CARD_STORED_ITEM))) {
            --this.size;
            this.markDirty();
            return CaptchaCardItem.createCardWithItem(item, player.server);
        }
        return item;
    }

    @Override
    protected void fillList(NonNullList<ItemStack> items) {
        items.clear();
        Iterator iter = this.list.iterator();
        for (int i = 0; i < this.size; ++i) {
            if (i < this.size - this.list.size()) {
                items.add((Object)ItemStack.EMPTY);
                continue;
            }
            items.add((Object)((ItemStack)iter.next()));
        }
    }
}

