/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;

public class SetModus
extends Modus {
    protected int size;
    protected NonNullList<ItemStack> list;
    protected boolean changed;
    protected NonNullList<ItemStack> items;

    public SetModus(ModusType<? extends SetModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public void initModus(ItemStack modusItem, ServerPlayer player, NonNullList<ItemStack> prev, int size) {
        this.size = size;
        this.list = NonNullList.create();
        if (this.side == LogicalSide.CLIENT) {
            this.items = NonNullList.create();
            this.changed = true;
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        this.size = nbt.getInt("size");
        this.list = NonNullList.create();
        for (int i = 0; i < this.size && nbt.contains("item" + i, 10); ++i) {
            this.list.add((Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound("item" + i)).orElseThrow()));
        }
        if (this.side == LogicalSide.CLIENT) {
            if (this.items == null) {
                this.items = NonNullList.create();
            }
            this.changed = true;
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("size", this.size);
        Iterator iter = this.list.iterator();
        for (int i = 0; i < this.list.size(); ++i) {
            ItemStack stack = (ItemStack)iter.next();
            nbt.put("item" + i, stack.save(provider));
        }
        return nbt;
    }

    @Override
    public boolean putItemStack(ServerPlayer player, ItemStack item) {
        if (this.size <= this.list.size() || item.isEmpty()) {
            return false;
        }
        for (ItemStack stack : this.list) {
            if (stack.getItem() != item.getItem()) continue;
            CaptchaDeckHandler.launchItem(player, item);
            return true;
        }
        if (item.getCount() > 1) {
            ItemStack stack = item.copy();
            stack.shrink(1);
            item.setCount(1);
            CaptchaDeckHandler.launchItem(player, stack);
        }
        this.list.add((Object)item);
        this.markDirty();
        return true;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        if (this.side == LogicalSide.SERVER) {
            NonNullList items = NonNullList.create();
            this.fillList((NonNullList<ItemStack>)items);
            return items;
        }
        if (this.changed) {
            this.fillList(this.items);
        }
        return this.items;
    }

    protected void fillList(NonNullList<ItemStack> items) {
        items.clear();
        Iterator iter = this.list.iterator();
        for (int i = 0; i < this.size; ++i) {
            if (iter.hasNext()) {
                items.add((Object)((ItemStack)iter.next()));
                continue;
            }
            items.add((Object)ItemStack.EMPTY);
        }
    }

    @Override
    public boolean increaseSize(ServerPlayer player) {
        if ((Integer)MinestuckConfig.SERVER.modusMaxSize.get() > 0 && this.size >= (Integer)MinestuckConfig.SERVER.modusMaxSize.get()) {
            return false;
        }
        ++this.size;
        this.markDirty();
        return true;
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (ItemStack item : this.list) {
                CaptchaDeckHandler.launchAnyItem((Player)player, item);
            }
            this.list.clear();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.list.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = (ItemStack)this.list.remove(id);
        this.markDirty();
        if (asCard) {
            --this.size;
            this.markDirty();
            item = CaptchaCardItem.createCardWithItem(item, player.server);
        }
        return item;
    }

    @Override
    public boolean canSwitchFrom(Modus modus) {
        return false;
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

