/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;

public class StackModus
extends Modus {
    protected int size;
    protected LinkedList<ItemStack> list;
    protected boolean changed;
    protected NonNullList<ItemStack> items;

    public StackModus(ModusType<? extends StackModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public void initModus(ItemStack modusItem, ServerPlayer player, NonNullList<ItemStack> prev, int size) {
        this.size = size;
        this.list = new LinkedList();
        if (prev != null) {
            for (ItemStack stack : prev) {
                if (stack.isEmpty()) continue;
                this.list.add(stack);
            }
        }
        if (player.level().isClientSide) {
            this.items = NonNullList.create();
            this.changed = prev != null;
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        this.size = nbt.getInt("size");
        this.list = new LinkedList();
        for (int i = 0; i < this.size && nbt.contains("item" + i, 10); ++i) {
            this.list.add((ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound("item" + i)).orElseThrow());
        }
        if (this.side == LogicalSide.CLIENT) {
            this.items = NonNullList.create();
            this.changed = true;
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("size", this.size);
        Iterator iter = this.list.iterator();
        for (int i = 0; i < this.list.size(); ++i) {
            ItemStack stack = (ItemStack)iter.next();
            nbt.put("item" + i, stack.save(provider));
        }
        return nbt;
    }

    @Override
    public boolean putItemStack(ServerPlayer player, ItemStack item) {
        ItemStack firstItem;
        if (this.size == 0 || item.isEmpty()) {
            return false;
        }
        ItemStack itemStack = firstItem = !this.list.isEmpty() ? this.list.getFirst() : ItemStack.EMPTY;
        if (ItemStack.isSameItemSameComponents((ItemStack)firstItem, (ItemStack)item) && firstItem.getCount() + item.getCount() <= firstItem.getMaxStackSize()) {
            firstItem.grow(item.getCount());
        } else if (this.list.size() < this.size) {
            this.list.addFirst(item);
            this.markDirty();
        } else {
            this.list.addFirst(item);
            this.markDirty();
            CaptchaDeckHandler.launchItem(player, this.list.removeLast());
        }
        return true;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        if (this.side == LogicalSide.SERVER) {
            NonNullList items = NonNullList.create();
            this.fillList((NonNullList<ItemStack>)items);
            return items;
        }
        if (this.changed) {
            this.fillList(this.items);
        }
        return this.items;
    }

    protected void fillList(NonNullList<ItemStack> items) {
        items.clear();
        Iterator iter = this.list.iterator();
        for (int i = 0; i < this.size; ++i) {
            if (iter.hasNext()) {
                items.add((Object)((ItemStack)iter.next()));
                continue;
            }
            items.add((Object)ItemStack.EMPTY);
        }
    }

    @Override
    public boolean increaseSize(ServerPlayer player) {
        if ((Integer)MinestuckConfig.SERVER.modusMaxSize.get() > 0 && this.size >= (Integer)MinestuckConfig.SERVER.modusMaxSize.get()) {
            return false;
        }
        ++this.size;
        this.markDirty();
        return true;
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (ItemStack item : this.list) {
                CaptchaDeckHandler.launchAnyItem((Player)player, item);
            }
            this.list.clear();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (asCard) {
            --this.size;
            this.markDirty();
            return CaptchaCardItem.createCardWithItem(this.list.removeFirst(), player.server);
        }
        this.markDirty();
        return this.list.removeFirst();
    }

    @Override
    public boolean canSwitchFrom(Modus modus) {
        return modus instanceof StackModus;
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

