/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.inventory.captchalogue.ModusTypes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public final class StartingModusManager
extends SimplePreparableReloadListener<List<String>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    public static final String PATH = "minestuck/config/starting_modus.json";
    private static StartingModusManager INSTANCE;
    private List<ModusType<?>> startingModusTypes;

    protected List<String> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<String> modusTypes = new ArrayList<String>();
        for (String namespace : resourceManager.getNamespaces()) {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)PATH);
            resourceManager.getResource(location).ifPresent(resource -> {
                try (BufferedReader reader2 = resource.openAsReader();
                     JsonReader jsonreader = new JsonReader((Reader)reader2);){
                    modusTypes.addAll((Collection)GSON.getAdapter((TypeToken)new TypeToken<ArrayList<String>>(this){}).read(jsonreader));
                }
                catch (IOException reader2) {
                }
                catch (RuntimeException runtimeexception) {
                    LOGGER.warn("Invalid json in data pack: '{}'", (Object)location.toString(), (Object)runtimeexception);
                }
            });
        }
        return modusTypes;
    }

    protected void apply(List<String> modusTypes, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.startingModusTypes = modusTypes.stream().map(this::createModus).collect(Collectors.toList());
    }

    private ModusType<?> createModus(String key) {
        ModusType modusType;
        ResourceLocation name = ResourceLocation.tryParse((String)key);
        if (name == null) {
            LOGGER.error("Unable to parse starting modus type {} as a resource location!", (Object)key);
        }
        if ((modusType = (ModusType)ModusTypes.REGISTRY.get(name)) == null) {
            LOGGER.error("Unable to get the modus type '{}' from the registry", (Object)name);
        }
        return modusType;
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        INSTANCE = new StartingModusManager();
        event.addListener((PreparableReloadListener)INSTANCE);
    }

    public static List<ModusType<?>> getStartingModusTypes() {
        return StartingModusManager.INSTANCE.startingModusTypes;
    }
}

