/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.captchalogue;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;

public class TreeModus
extends Modus {
    public TreeNode node;
    public int size;
    public boolean autoBalance = true;

    public TreeModus(ModusType<? extends TreeModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public void initModus(ItemStack modusItem, ServerPlayer player, NonNullList<ItemStack> prev, int size) {
        this.size = size;
        this.node = null;
    }

    @Override
    public void readFromNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        this.size = nbt.getInt("size");
        this.autoBalance = nbt.getBoolean("auto_balance");
        this.node = TreeModus.readNode(nbt, 0, 0, provider);
        if (this.side == LogicalSide.SERVER) {
            this.autoBalance();
        }
    }

    private static TreeNode readNode(CompoundTag nbt, int currentIndex, int level, HolderLookup.Provider provider) {
        if (nbt.contains("node" + currentIndex)) {
            ItemStack stack = (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound("node" + currentIndex)).orElseThrow();
            if (stack.isEmpty()) {
                return null;
            }
            TreeNode node = new TreeNode(stack);
            node.node1 = TreeModus.readNode(nbt, currentIndex + (int)Math.pow(2.0, level), level + 1, provider);
            node.node2 = TreeModus.readNode(nbt, currentIndex + (int)Math.pow(2.0, level + 1), level + 1, provider);
            return node;
        }
        return null;
    }

    private static void saveNode(CompoundTag nbt, TreeNode node, int currentIndex, int level, HolderLookup.Provider provider) {
        nbt.put("node" + currentIndex, node.stack.save(provider));
        if (node.node1 != null) {
            TreeModus.saveNode(nbt, node.node1, currentIndex + (int)Math.pow(2.0, level), level + 1, provider);
        }
        if (node.node2 != null) {
            TreeModus.saveNode(nbt, node.node2, currentIndex + (int)Math.pow(2.0, level + 1), level + 1, provider);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("size", this.size);
        nbt.putBoolean("auto_balance", this.autoBalance);
        if (this.node != null) {
            TreeModus.saveNode(nbt, this.node, 0, 0, provider);
        }
        return nbt;
    }

    @Override
    public boolean putItemStack(ServerPlayer player, ItemStack item) {
        int currentSize;
        int n = currentSize = this.node == null ? 0 : this.node.getSize();
        if (item.isEmpty() || currentSize >= this.size) {
            return false;
        }
        if (this.node == null) {
            this.node = new TreeNode(item);
        } else {
            this.node.addNode(new TreeNode(item));
        }
        this.markDirty();
        this.autoBalance();
        return true;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        if (this.node == null) {
            return NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
        }
        NonNullList<ItemStack> list = this.node.getItems();
        while (list.size() < this.size) {
            list.add((Object)ItemStack.EMPTY);
        }
        return list;
    }

    @Override
    public int getNonEmptyCards() {
        return this.node.getSize();
    }

    @Override
    public boolean increaseSize(ServerPlayer player) {
        if ((Integer)MinestuckConfig.SERVER.modusMaxSize.get() > 0 && this.size >= (Integer)MinestuckConfig.SERVER.modusMaxSize.get()) {
            return false;
        }
        ++this.size;
        this.markDirty();
        return true;
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.size <= 0 && (this.node == null || this.size > this.node.getSize())) {
                return ItemStack.EMPTY;
            }
            --this.size;
            this.markDirty();
            return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
        }
        if (this.node == null) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            ArrayList<ItemStack> list = this.node.removeItems(0);
            this.node = null;
            this.markDirty();
            for (ItemStack stack : list) {
                CaptchaDeckHandler.launchAnyItem((Player)player, stack);
            }
            return ItemStack.EMPTY;
        }
        if (id == 0) {
            MSCriteriaTriggers.TREE_MODUS_ROOT.get().trigger(player, this.node.getSize());
        }
        ArrayList<ItemStack> list = this.node.removeItems(id);
        this.markDirty();
        if (list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            CaptchaDeckHandler.launchAnyItem((Player)player, list.get(i));
        }
        if (asCard) {
            --this.size;
            this.markDirty();
            stack = CaptchaCardItem.createCardWithItem(stack, player.server);
        }
        if (id == 0) {
            this.node = null;
        }
        this.autoBalance();
        return stack;
    }

    @Override
    public boolean canSwitchFrom(Modus modus) {
        return false;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setValue(ServerPlayer player, byte type, int value) {
        if (this.autoBalance != value > 0) {
            this.autoBalance = value > 0;
            this.markDirty();
            if (this.autoBalance) {
                this.autoBalance();
            }
        }
    }

    protected void autoBalance() {
        int maxDepth;
        if (!this.autoBalance && MinestuckConfig.SERVER.treeModusSetting.get() != MinestuckConfig.AvailableOptions.ON || MinestuckConfig.SERVER.treeModusSetting.get() == MinestuckConfig.AvailableOptions.OFF) {
            return;
        }
        int minDepth = this.getDepth(this.node, true);
        if (minDepth + 1 < (maxDepth = this.getDepth(this.node, false))) {
            NonNullList<ItemStack> list = this.node.getItems();
            this.node = this.createNode((List<ItemStack>)list);
            this.markDirty();
        }
    }

    protected TreeNode createNode(List<ItemStack> list) {
        if (list.isEmpty()) {
            return null;
        }
        int i = list.size() / 2;
        TreeNode node = new TreeNode(list.get(i));
        node.node1 = this.createNode(list.subList(0, i));
        node.node2 = this.createNode(list.subList(i + 1, list.size()));
        return node;
    }

    protected int getDepth(TreeNode node, boolean min) {
        if (node == null) {
            return 0;
        }
        if (min) {
            return Math.min(this.getDepth(node.node1, true), this.getDepth(node.node2, true)) + 1;
        }
        return Math.max(this.getDepth(node.node1, false), this.getDepth(node.node2, false)) + 1;
    }

    public static class TreeNode {
        public final ItemStack stack;
        public TreeNode node1;
        public TreeNode node2;

        protected TreeNode(ItemStack stack) {
            this.stack = stack;
        }

        public int getSize() {
            int size = 1;
            if (this.node1 != null) {
                size += this.node1.getSize();
            }
            if (this.node2 != null) {
                size += this.node2.getSize();
            }
            return size;
        }

        public void addNode(TreeNode node) {
            if (ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)node.stack) && this.stack.getCount() + node.stack.getCount() <= this.stack.getMaxStackSize()) {
                this.stack.grow(node.stack.getCount());
            } else {
                int compare = this.itemToString().compareTo(node.itemToString());
                if (compare >= 0) {
                    if (this.node1 != null) {
                        this.node1.addNode(node);
                    } else {
                        this.node1 = node;
                    }
                } else if (this.node2 != null) {
                    this.node2.addNode(node);
                } else {
                    this.node2 = node;
                }
            }
        }

        private String itemToString() {
            ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem());
            if (name == null) {
                throw new IllegalStateException("Item " + String.valueOf(this.stack.getItem()) + " does not have a registry name, but ended up in a tree modus!");
            }
            return name.getPath() + ":" + name.getNamespace();
        }

        public ArrayList<ItemStack> removeItems(int index) {
            if (index == 0) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                list.add(this.stack);
                if (this.node1 != null) {
                    list.addAll((Collection<ItemStack>)this.node1.getItems());
                }
                if (this.node2 != null) {
                    list.addAll((Collection<ItemStack>)this.node2.getItems());
                }
                return list;
            }
            if (--index % 2 == 0) {
                if (this.node1 != null) {
                    ArrayList<ItemStack> list = this.node1.removeItems(index / 2);
                    if (index / 2 == 0) {
                        this.node1 = null;
                    }
                    return list;
                }
                return new ArrayList<ItemStack>();
            }
            if (this.node2 != null) {
                ArrayList<ItemStack> list = this.node2.removeItems(index / 2);
                if (index / 2 == 0) {
                    this.node2 = null;
                }
                return list;
            }
            return new ArrayList<ItemStack>();
        }

        public NonNullList<ItemStack> getItems() {
            NonNullList list = NonNullList.create();
            if (this.node1 != null) {
                list.addAll(this.node1.getItems());
            }
            list.add((Object)this.stack);
            if (this.node2 != null) {
                list.addAll(this.node2.getItems());
            }
            return list;
        }
    }
}

