/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.inventory.musicplayer;

import com.mraof.minestuck.inventory.ContainerHelper;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.util.MSTags;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class CassetteContainerMenu
extends AbstractContainerMenu {
    private static final int CASSETTE_X = 80;
    private static final int CASSETTE_Y = 36;
    private static final int SLOT_INDEX = 0;
    private final ItemStack musicPlayer;

    public CassetteContainerMenu(int windowId, Inventory playerInventory, final ItemStack musicPlayer, ItemStack storedCassette) {
        super(MSMenuTypes.CASSETTE_CONTAINER.get(), windowId);
        this.musicPlayer = musicPlayer;
        this.addSlot(new Slot(this, (Container)new SimpleContainer(new ItemStack[]{storedCassette}), 0, 80, 36){

            public boolean mayPlace(@Nonnull ItemStack stack) {
                return stack.is(MSTags.Items.CASSETTES);
            }

            public void setChanged() {
                super.setChanged();
                musicPlayer.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(this.getItem())));
            }
        });
        ContainerHelper.addPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), 8, 84, playerInventory);
    }

    public CassetteContainerMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, ItemStack.EMPTY, ItemStack.EMPTY);
    }

    public boolean stillValid(Player playerIn) {
        ItemStack main = playerIn.getMainHandItem();
        ItemStack off = playerIn.getOffhandItem();
        return !main.isEmpty() && main == this.musicPlayer || !off.isEmpty() && off == this.musicPlayer;
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        int allSlots = this.slots.size();
        if (slot.hasItem()) {
            ItemStack itemstackOrig = slot.getItem();
            itemstack = itemstackOrig.copy();
            boolean result = false;
            if (slotNumber <= 0) {
                result = this.moveItemStackTo(itemstackOrig, 1, allSlots, false);
            } else if (itemstackOrig.is(MSTags.Items.CASSETTES)) {
                result = this.moveItemStackTo(itemstackOrig, 0, 1, false);
            }
            if (!result) {
                return ItemStack.EMPTY;
            }
            slot.setChanged();
        }
        return itemstack;
    }
}

