/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.item.BarbasolBombEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BarbasolBombItem
extends Item
implements ProjectileItem {
    public BarbasolBombItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerProjectileBehavior((ItemLike)this);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        BarbasolBombEntity barbasolBomb = new BarbasolBombEntity(MSEntityTypes.BARBASOL_BOMB.get(), pos.x(), pos.y(), pos.z(), level);
        barbasolBomb.setItem(stack);
        return barbasolBomb;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack item = playerIn.getItemInHand(handIn);
        if (!playerIn.isCreative()) {
            item.shrink(1);
        }
        level.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.TNT_PRIMED, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (!level.isClientSide) {
            BarbasolBombEntity bomb = new BarbasolBombEntity(MSEntityTypes.BARBASOL_BOMB.get(), (LivingEntity)playerIn, level, playerIn.getAbilities().mayBuild);
            bomb.setItem(item);
            bomb.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), -20.0f, 0.7f, 1.0f);
            level.addFreshEntity((Entity)bomb);
        }
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)item);
    }
}

