/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
public class BoondollarsItem
extends Item {
    public BoondollarsItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            PlayerData.get(serverPlayer).ifPresent(playerData -> PlayerBoondollars.addBoondollars(playerData, BoondollarsItem.getCount(playerIn.getItemInHand(handIn))));
        }
        return InteractionResultHolder.success((Object)ItemStack.EMPTY);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        long amount = BoondollarsItem.getCount(stack);
        tooltip.add((Component)Component.translatable((String)"item.minestuck.boondollars.amount", (Object[])new Object[]{amount}));
    }

    public static long getCount(ItemStack stack) {
        return (Long)stack.getOrDefault(MSItemComponents.VALUE, (Object)1L);
    }

    public static ItemStack setCount(ItemStack stack, long value) {
        stack.set(MSItemComponents.VALUE, (Object)value);
        return stack;
    }
}

