/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.CaptchaCodeComponent;
import com.mraof.minestuck.item.components.CardStoredItemComponent;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.util.MSTags;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CaptchaCardItem
extends Item {
    public CaptchaCardItem(Item.Properties properties) {
        super(properties.component(MSItemComponents.CAPTCHA_CODE, (Object)CaptchaCodeComponent.ZERO));
    }

    public int getMaxStackSize(ItemStack stack) {
        if (stack.has(MSItemComponents.CARD_STORED_ITEM) || stack.has(MSItemComponents.ENCODED_ITEM)) {
            return 16;
        }
        return 64;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown() && ((CardStoredItemComponent)stack.getOrDefault(MSItemComponents.CARD_STORED_ITEM, (Object)CardStoredItemComponent.EMPTY)).isGhostItem()) {
            stack.remove(MSItemComponents.CARD_STORED_ITEM);
            return InteractionResultHolder.success((Object)new ItemStack((ItemLike)stack.getItem(), stack.getCount()));
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        EncodedItemComponent encodedItemComponent = (EncodedItemComponent)stack.get(MSItemComponents.ENCODED_ITEM);
        CardStoredItemComponent cardStoredItemComponent = (CardStoredItemComponent)stack.get(MSItemComponents.CARD_STORED_ITEM);
        if (encodedItemComponent != null) {
            ItemStack content = encodedItemComponent.asItemStack();
            if (!content.isEmpty()) {
                Component contentName = content.getHoverName();
                tooltipComponents.add(CaptchaCardItem.makeTooltipInfo(contentName));
                tooltipComponents.add(CaptchaCardItem.makeTooltipInfo((Component)Component.translatable((String)(this.getDescriptionId() + ".punched"))));
            } else {
                tooltipComponents.add(CaptchaCardItem.makeTooltipInfo((Component)Component.translatable((String)(this.getDescriptionId() + ".invalid"))));
            }
        } else if (cardStoredItemComponent != null) {
            ItemStack content = cardStoredItemComponent.storedStack();
            if (!content.isEmpty()) {
                Component contentName = content.getHoverName();
                tooltipComponents.add(CaptchaCardItem.makeTooltipInfo((Component)(cardStoredItemComponent.isGhostItem() ? contentName : Component.literal((String)(content.getCount() + "x")).append(contentName))));
                CaptchaCodeComponent captchaCode = (CaptchaCodeComponent)stack.get(MSItemComponents.CAPTCHA_CODE);
                if (captchaCode != null) {
                    tooltipComponents.add((Component)Component.literal((String)captchaCode.code()));
                }
                if (cardStoredItemComponent.isGhostItem()) {
                    tooltipComponents.add(CaptchaCardItem.makeTooltipInfo((Component)Component.translatable((String)(this.getDescriptionId() + ".ghost"))));
                }
            } else {
                tooltipComponents.add(CaptchaCardItem.makeTooltipInfo((Component)Component.translatable((String)(this.getDescriptionId() + ".invalid"))));
            }
        } else {
            tooltipComponents.add((Component)Component.literal((String)"00000000"));
            tooltipComponents.add(CaptchaCardItem.makeTooltipInfo((Component)Component.translatable((String)(this.getDescriptionId() + ".empty"))));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CaptchaCodeComponent existingCode = (CaptchaCodeComponent)stack.get(MSItemComponents.CAPTCHA_CODE);
        if (existingCode == null || existingCode.hasRefreshed()) {
            return;
        }
        CardStoredItemComponent storedItem = (CardStoredItemComponent)stack.get(MSItemComponents.CARD_STORED_ITEM);
        if (storedItem != null) {
            stack.set(MSItemComponents.CAPTCHA_CODE, (Object)CaptchaCodeComponent.createFor(storedItem.storedStack(), serverLevel.getServer()));
        }
    }

    private static Component makeTooltipInfo(Component info) {
        return Component.literal((String)"(").append(info).append(")").withStyle(ChatFormatting.GRAY);
    }

    public static ItemStack createCardWithItem(ItemStack storedStack, MinecraftServer mcServer) {
        return CaptchaCardItem.createCardWithStorage(new CardStoredItemComponent(storedStack, false), mcServer);
    }

    public static ItemStack createGhostCard(ItemStack ghostStack, MinecraftServer mcServer) {
        return CaptchaCardItem.createCardWithStorage(new CardStoredItemComponent(ghostStack, true), mcServer);
    }

    private static ItemStack createCardWithStorage(CardStoredItemComponent component, MinecraftServer mcServer) {
        ItemStack cardStack = new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
        cardStack.set(MSItemComponents.CARD_STORED_ITEM, (Object)component);
        if (component.storedStack().is(MSTags.Items.UNREADABLE)) {
            cardStack.remove(MSItemComponents.CAPTCHA_CODE);
        } else {
            cardStack.set(MSItemComponents.CAPTCHA_CODE, (Object)CaptchaCodeComponent.createFor(component.storedStack(), mcServer));
        }
        return cardStack;
    }

    public static ItemStack createPunchedCard(Item encodedItem) {
        return EncodedItemComponent.createEncoded(MSItems.CAPTCHA_CARD, encodedItem);
    }

    public static boolean isUnpunchedCard(ItemStack stack) {
        return stack.is(MSItems.CAPTCHA_CARD) && !stack.has(MSItemComponents.ENCODED_ITEM);
    }
}

