/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.item.CaptchaCardItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CaptcharoidCameraItem
extends Item {
    public CaptcharoidCameraItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        Direction facing = context.getClickedFace();
        Boolean inside = context.isInside();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB bb = new AABB(pos.relative(facing));
            List list = level.getEntitiesOfClass(ItemFrame.class, bb);
            if (!list.isEmpty()) {
                ItemStack item = ((ItemFrame)list.get(0)).getItem();
                if (item.isEmpty()) {
                    item = new ItemStack((ItemLike)Items.ITEM_FRAME);
                }
                player.getInventory().add(CaptchaCardItem.createGhostCard(item, serverLevel.getServer()));
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            } else {
                BlockState state = level.getBlockState(pos);
                ItemStack block = state.getCloneItemStack((HitResult)new BlockHitResult(context.getClickLocation(), facing, pos, inside.booleanValue()), (LevelReader)level, pos, player);
                if (!block.isEmpty()) {
                    player.getInventory().add(CaptchaCardItem.createGhostCard(block, serverLevel.getServer()));
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }
}

