/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.block.CassettePlayerBlock;
import com.mraof.minestuck.block.EnumCassetteType;
import com.mraof.minestuck.block.MSBlocks;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
public class CassetteItem
extends Item {
    public final EnumCassetteType cassetteType;
    private final int comparatorValue;

    public CassetteItem(int comparatorValue, EnumCassetteType cassetteType, Item.Properties builder, int lengthInTicks) {
        super(builder);
        this.comparatorValue = comparatorValue;
        this.cassetteType = cassetteType;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        if (blockstate.getBlock() == MSBlocks.CASSETTE_PLAYER.get() && blockstate.getValue(CassettePlayerBlock.CASSETTE) == EnumCassetteType.NONE && ((Boolean)blockstate.getValue((Property)CassettePlayerBlock.OPEN)).booleanValue()) {
            ItemStack itemstack = context.getItemInHand();
            if (!level.isClientSide) {
                ((CassettePlayerBlock)((Object)MSBlocks.CASSETTE_PLAYER.get())).insertCassette((LevelAccessor)level, blockpos, blockstate, itemstack);
                itemstack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ResourceKey<JukeboxSong> songKey = this.cassetteType.getJukeboxSong();
        HolderLookup.Provider registries = context.registries();
        if (songKey != null && registries != null) {
            registries.lookup(songKey.registryKey()).flatMap(registry -> registry.get(songKey)).ifPresent(song -> {
                MutableComponent songDescription = ((JukeboxSong)song.value()).description().copy();
                ComponentUtils.mergeStyles((MutableComponent)songDescription, (Style)Style.EMPTY.withColor(ChatFormatting.GRAY));
                tooltipComponents.add((Component)songDescription);
            });
        }
    }

    public int getComparatorValue() {
        return this.comparatorValue;
    }
}

