/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomBoatItem
extends Item {
    private static final Predicate<Entity> CAN_COLLIDE_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    protected final BoatProvider provider;

    public CustomBoatItem(BoatProvider provider, Item.Properties properties) {
        super(properties);
        this.provider = provider;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new BehaviorDispenseCustomBoat());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        float partialTicks = 1.0f;
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult rayTrace = CustomBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (rayTrace.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 lookDirection = player.getViewVector(partialTicks);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(lookDirection.scale(5.0)).inflate(1.0), CAN_COLLIDE_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 eyePos = player.getEyePosition(partialTicks);
            if (list.stream().anyMatch(entity -> entity.getBoundingBox().inflate((double)entity.getPickRadius()).contains(eyePos))) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        Entity boat = this.provider.createBoat(itemstack, level, rayTrace.getLocation().x, rayTrace.getLocation().y, rayTrace.getLocation().z);
        boat.setYRot(player.getYRot());
        if (!level.noCollision(boat, boat.getBoundingBox().inflate(-0.1))) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!level.isClientSide) {
            level.addFreshEntity(boat);
        }
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)itemstack);
    }

    public static interface BoatProvider {
        public Entity createBoat(ItemStack var1, Level var2, double var3, double var5, double var7);
    }

    protected class BehaviorDispenseCustomBoat
    extends DefaultDispenseItemBehavior {
        protected BehaviorDispenseCustomBoat() {
        }

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double waterOffset;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = source.level();
            double x = source.center().x() + (double)((float)direction.getStepX() * 1.125f);
            double y = source.center().y() + (double)((float)direction.getStepY() * 1.125f);
            double z = source.center().z() + (double)((float)direction.getStepZ() * 1.125f);
            BlockPos pos = source.pos().relative(direction);
            double d = waterOffset = level.getFluidState(pos).is(FluidTags.WATER) ? 1.0 : 0.0;
            if (!level.getBlockState(pos).isAir() || !level.getFluidState(pos.below()).is(FluidTags.WATER)) {
                return new DefaultDispenseItemBehavior().dispense(source, stack);
            }
            Entity boat = CustomBoatItem.this.provider.createBoat(stack, (Level)level, x, y + waterOffset, z);
            boat.setYRot(direction.toYRot());
            level.addFreshEntity(boat);
            stack.shrink(1);
            return stack;
        }
    }
}

