/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.util.MSAttachments;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GutterBallItem
extends Item {
    public static final String MINOR_INCREASE = "message.gutter.minor_increase";

    public GutterBallItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BELL_RESONATE, SoundSource.PLAYERS, 0.5f, 0.3f);
        itemStack.shrink(1);
        player.displayClientMessage((Component)Component.translatable((String)MINOR_INCREASE).withStyle(ChatFormatting.BOLD), true);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerData.get(serverPlayer).ifPresent(playerData -> {
                double newMultiplier = (Double)playerData.getData(MSAttachments.GUTTER_MULTIPLIER) + 0.2;
                playerData.setData(MSAttachments.GUTTER_MULTIPLIER, newMultiplier);
            });
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".press_shift")));
        }
    }
}

