/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.util.MSAttachments;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GutterThumbDriveItem
extends Item {
    public static final String GREATER_INCREASE = "message.gutter.increase";

    public GutterThumbDriveItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player != null && level.getBlockEntity(blockPos) instanceof ComputerBlockEntity) {
            ItemStack itemStack = player.getItemInHand(player.getUsedItemHand());
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BELL_RESONATE, SoundSource.PLAYERS, 0.5f, 0.3f);
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_EQUIP_IRON, SoundSource.PLAYERS, 0.2f, 0.6f);
            itemStack.shrink(1);
            player.displayClientMessage((Component)Component.translatable((String)GREATER_INCREASE).withStyle(ChatFormatting.BOLD), true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerData.get(serverPlayer).ifPresent(playerData -> {
                    double newMultiplier = (Double)playerData.getData(MSAttachments.GUTTER_MULTIPLIER) + 2.0;
                    playerData.setData(MSAttachments.GUTTER_MULTIPLIER, newMultiplier);
                });
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".press_shift")));
        }
    }
}

