/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.computer.DiskBurnerData;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.ReadableSburbCodeItem;
import com.mraof.minestuck.item.components.HieroglyphCode;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.util.MSTags;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class IncompleteSburbCodeItem
extends ReadableSburbCodeItem {
    public IncompleteSburbCodeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean getParadoxInfo(ItemStack stack) {
        return stack.has(MSItemComponents.PARADOX_CODE);
    }

    @Override
    public Set<Block> getRecordedBlocks(ItemStack stack) {
        return HieroglyphCode.getBlocks(stack);
    }

    @Override
    protected boolean useOnComputer(ItemStack heldStack, Player player, InteractionHand hand, BlockPos pos, DiskBurnerData diskBurnerData) {
        boolean success = super.useOnComputer(heldStack, player, hand, pos, diskBurnerData);
        boolean changedItem = false;
        if (diskBurnerData.isHasParadoxInfoStored() && !this.getParadoxInfo(heldStack)) {
            heldStack.set(MSItemComponents.PARADOX_CODE, (Object)Unit.INSTANCE);
            changedItem = true;
        }
        for (Block iterateBlock : diskBurnerData.getHieroglyphsStored()) {
            if (!iterateBlock.defaultBlockState().is(MSTags.Blocks.GREEN_HIEROGLYPHS)) continue;
            changedItem |= HieroglyphCode.addBlock(heldStack, iterateBlock);
        }
        if (changedItem) {
            this.attemptConversionToCompleted(player, hand);
        }
        return success || changedItem;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stackInUse = context.getItemInHand();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand handIn = context.getHand();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockState state = level.getBlockState(context.getClickedPos());
        if (!state.is(MSTags.Blocks.GREEN_HIEROGLYPHS)) {
            return InteractionResult.FAIL;
        }
        if (!HieroglyphCode.addBlock(stackInUse, state.getBlock())) {
            return InteractionResult.FAIL;
        }
        level.playSound(null, player.blockPosition(), SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.attemptConversionToCompleted(player, handIn);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private void attemptConversionToCompleted(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        Set<Block> recordedSet = this.getRecordedBlocks(stackInHand);
        if (IncompleteSburbCodeItem.hasAllBlocks(recordedSet) && this.getParadoxInfo(stackInHand)) {
            player.setItemInHand(hand, ((Item)MSItems.COMPLETED_SBURB_CODE.get()).getDefaultInstance());
        }
    }

    public static boolean hasAllBlocks(Set<Block> hieroglyphs) {
        return hieroglyphs.containsAll(MSTags.getBlocksFromTag(MSTags.Blocks.GREEN_HIEROGLYPHS));
    }

    private float percentCompletion(ItemStack stack) {
        boolean mod = this.getParadoxInfo(stack);
        float sizeOfList = this.getRecordedBlocks(stack).size();
        return (sizeOfList + (float)mod) / (float)(MSTags.getBlocksFromTag(MSTags.Blocks.GREEN_HIEROGLYPHS).size() + 1) * 100.0f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.minestuck.sburb_code.completion", (Object[])new Object[]{(byte)this.percentCompletion(stack)}));
        if (IncompleteSburbCodeItem.hasAllBlocks(this.getRecordedBlocks(stack))) {
            tooltip.add((Component)Component.translatable((String)"item.minestuck.sburb_code.paradox_hint"));
        }
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"item.minestuck.sburb_code.additional_info"));
        } else {
            tooltip.add((Component)Component.translatable((String)"message.shift_for_more_info"));
        }
    }
}

