/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.item.MSItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public final class MSDispenserBehaviours {
    static DefaultDispenseItemBehavior DISPENSE_BUCKET = new DefaultDispenseItemBehavior(){

        protected ItemStack execute(BlockSource source, ItemStack stack) {
            DispensibleContainerItem item = (DispensibleContainerItem)stack.getItem();
            BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            ServerLevel level = source.level();
            if (item.emptyContents(null, (Level)level, blockpos, null, stack)) {
                item.checkExtraContent(null, (Level)level, stack, blockpos);
                return Items.BUCKET.getDefaultInstance();
            }
            return super.execute(source, stack);
        }
    };

    public static void registerBehaviours() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)MSItems.OIL_BUCKET.get()), (DispenseItemBehavior)DISPENSE_BUCKET);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)MSItems.BLOOD_BUCKET.get()), (DispenseItemBehavior)DISPENSE_BUCKET);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)MSItems.BRAIN_JUICE_BUCKET.get()), (DispenseItemBehavior)DISPENSE_BUCKET);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)MSItems.WATER_COLORS_BUCKET.get()), (DispenseItemBehavior)DISPENSE_BUCKET);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)MSItems.ENDER_BUCKET.get()), (DispenseItemBehavior)DISPENSE_BUCKET);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)MSItems.LIGHT_WATER_BUCKET.get()), (DispenseItemBehavior)DISPENSE_BUCKET);
    }
}

