/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class ObsidianBucketItem
extends Item {
    public ObsidianBucketItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(this){

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = source.pos().relative(direction);
                this.setSuccess(((BlockItem)Items.OBSIDIAN).place((BlockPlaceContext)new DirectionalPlaceContext((Level)source.level(), blockpos, direction, Items.OBSIDIAN.getDefaultInstance(), Direction.UP)).consumesAction());
                if (this.isSuccess()) {
                    return Items.BUCKET.getDefaultInstance();
                }
                return super.execute(source, stack);
            }
        });
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        level.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        if (!playerIn.getInventory().add(new ItemStack((ItemLike)Blocks.OBSIDIAN)) && !level.isClientSide) {
            playerIn.drop(new ItemStack((ItemLike)Blocks.OBSIDIAN), false);
        }
        return InteractionResultHolder.success((Object)new ItemStack((ItemLike)Items.BUCKET));
    }
}

