/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.entity.item.PosterEntity;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.item.components.PosterComponent;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class PosterItem
extends Item {
    public PosterItem(PosterComponent posterComponent, Item.Properties properties) {
        super(properties.component(MSItemComponents.POSTER, (Object)posterComponent));
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos blockpos = pContext.getClickedPos();
        Direction direction = pContext.getClickedFace();
        BlockPos blockpos1 = blockpos.relative(direction);
        Player player = pContext.getPlayer();
        ItemStack itemstack = pContext.getItemInHand();
        Level level = pContext.getLevel();
        PosterComponent posterComponent = (PosterComponent)itemstack.get(MSItemComponents.POSTER);
        if (posterComponent == null || player != null && !this.mayPlace(player, direction, itemstack, blockpos1)) {
            return InteractionResult.FAIL;
        }
        Optional<PosterEntity> optional = PosterEntity.createArt(level, blockpos1, direction, itemstack, posterComponent.variantPool());
        if (optional.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        PosterEntity hangingentity = optional.get();
        if (hangingentity.survives()) {
            if (!level.isClientSide) {
                hangingentity.playPlacementSound();
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hangingentity.position());
                level.addFreshEntity((Entity)hangingentity);
            }
            itemstack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player pPlayer, Direction pDirection, ItemStack pHangingEntityStack, BlockPos pPos) {
        return !pDirection.getAxis().isVertical() && pPlayer.mayUseItemAt(pPos, pDirection, pHangingEntityStack);
    }
}

