/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
public class RazorBladeItem
extends Item {
    public RazorBladeItem(Item.Properties properties) {
        super(properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (attacker instanceof Player && !(player = (Player)attacker).isCreative()) {
            ItemEntity razor = new ItemEntity(attacker.level(), attacker.getX(), attacker.getY(), attacker.getZ(), stack.copy());
            if (!attacker.level().isClientSide) {
                razor.getItem().setCount(1);
                razor.setPickUpDelay(40);
                attacker.level().addFreshEntity((Entity)razor);
                stack.shrink(1);
                attacker.sendSystemMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".cut_self")));
            }
            attacker.setHealth(attacker.getHealth() - 1.0f);
            return true;
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Player player;
        if (entityLiving instanceof Player && !(player = (Player)entityLiving).isCreative()) {
            if (!level.isClientSide) {
                ItemEntity razor = new ItemEntity(entityLiving.level(), entityLiving.getX(), entityLiving.getY(), entityLiving.getZ(), stack.copy());
                razor.getItem().setCount(1);
                razor.setPickUpDelay(40);
                level.addFreshEntity((Entity)razor);
                stack.shrink(1);
                entityLiving.sendSystemMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".cut_self")));
            }
            entityLiving.hurt(level.damageSources().generic(), 1.0f);
        }
        return super.mineBlock(stack, level, state, pos, entityLiving);
    }
}

