/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.computer.DiskBurnerData;
import com.mraof.minestuck.computer.ProgramTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.util.MSTags;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class ReadableSburbCodeItem
extends Item {
    public ReadableSburbCodeItem(Item.Properties properties) {
        super(properties);
    }

    public abstract boolean getParadoxInfo(ItemStack var1);

    public abstract Set<Block> getRecordedBlocks(ItemStack var1);

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemStackIn = playerIn.getItemInHand(handIn);
        if (levelIn.isClientSide()) {
            MSScreenFactories.displayReadableSburbCodeScreen(this.getRecordedBlocks(itemStackIn), this.getParadoxInfo(itemStackIn));
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStackIn, (boolean)levelIn.isClientSide());
    }

    public InteractionResult onItemUseFirst(ItemStack heldStack, UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockPos pos = context.getClickedPos();
        if (player != null && (blockEntity = level.getBlockEntity(pos)) instanceof ComputerBlockEntity) {
            ComputerBlockEntity computer = (ComputerBlockEntity)blockEntity;
            Optional diskBurnerData = computer.getProgramData(ProgramTypes.DISK_BURNER);
            if (diskBurnerData.isPresent() && this.useOnComputer(heldStack, player, hand, pos, (DiskBurnerData)diskBurnerData.get())) {
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    protected boolean useOnComputer(ItemStack heldStack, Player player, InteractionHand hand, BlockPos pos, DiskBurnerData diskBurnerData) {
        boolean newInfo = diskBurnerData.recordNewInfo(this.getParadoxInfo(heldStack), this.getRecordedBlocks(heldStack));
        if (newInfo) {
            player.level().playSound(null, pos, MSSoundEvents.COMPUTER_KEYBOARD.get(), SoundSource.BLOCKS);
        }
        return newInfo;
    }

    public static class Completed
    extends ReadableSburbCodeItem {
        public Completed(Item.Properties properties) {
            super(properties);
        }

        @Override
        public boolean getParadoxInfo(ItemStack stack) {
            return true;
        }

        @Override
        public Set<Block> getRecordedBlocks(ItemStack stack) {
            return MSTags.getBlocksFromTag(MSTags.Blocks.GREEN_HIEROGLYPHS);
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"item.minestuck.completed_sburb_code.additional_info"));
            } else {
                tooltip.add((Component)Component.translatable((String)"message.shift_for_more_info"));
            }
        }
    }
}

