/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item;

import com.mojang.logging.LogUtils;
import com.mraof.minestuck.item.components.MSItemComponents;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StructureScannerItem
extends Item {
    public static final String ON = "message.temple_scanner.on";
    public static final String OFF = "message.temple_scanner.off";
    public static final String MISSING_FUEL = "message.temple_scanner.missing_fuel";
    public static final String NO_TARGET = "message.temple_scanner.no_target";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final TagKey<Structure> structure;
    @Nullable
    private final Supplier<Item> fuelItem;
    private final int powerCapacity;

    public StructureScannerItem(Item.Properties properties, TagKey<Structure> structure, @Nullable Supplier<Item> fuelItem, int powerCapacity) {
        super(properties.stacksTo(1));
        this.structure = structure;
        this.fuelItem = fuelItem;
        this.powerCapacity = powerCapacity;
    }

    public static boolean isPowered(ItemStack stack) {
        return StructureScannerItem.getPower(stack) > 0;
    }

    public static int getPower(ItemStack stack) {
        return (Integer)stack.getOrDefault(MSItemComponents.POWER, (Object)0);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (StructureScannerItem.isPowered(stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.fuelItem != null && !player.isCreative()) {
            ItemStack invItem = StructureScannerItem.findItem(player, this.fuelItem.get());
            if (invItem == null) {
                player.sendSystemMessage((Component)Component.translatable((String)MISSING_FUEL).withStyle(ChatFormatting.RED));
                return InteractionResultHolder.fail((Object)stack);
            }
            if (!this.tryActivateScanner(serverLevel, player, stack)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            StructureScannerItem.consumeFuelItem(invItem, player, serverLevel);
        } else if (!this.tryActivateScanner(serverLevel, player, stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    @Nullable
    private static ItemStack findItem(Player player, Item item) {
        for (ItemStack invItem : player.getInventory().items) {
            if (!invItem.is(item)) continue;
            return invItem;
        }
        return null;
    }

    private static void consumeFuelItem(ItemStack fuelStack, Player player, ServerLevel level) {
        fuelStack.shrink(1);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BLAZE_SHOOT, SoundSource.AMBIENT, 0.4f, 2.0f);
    }

    private boolean tryActivateScanner(ServerLevel level, Player player, ItemStack stack) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.AMBIENT, 0.8f, 1.3f);
        GlobalPos pos = this.findStructureTarget((Entity)player, level);
        if (pos == null) {
            player.sendSystemMessage((Component)Component.translatable((String)NO_TARGET).withStyle(ChatFormatting.RED));
            return false;
        }
        stack.set(MSItemComponents.TARGET_LOCATION, (Object)pos);
        stack.set(MSItemComponents.POWER, (Object)this.powerCapacity);
        player.sendSystemMessage((Component)Component.translatable((String)ON).withStyle(ChatFormatting.DARK_GREEN));
        return true;
    }

    @Nullable
    private GlobalPos findStructureTarget(Entity entity, ServerLevel level) {
        BlockPos pos = level.findNearestMapStructure(this.structure, entity.blockPosition(), 100, false);
        return pos == null ? null : GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide && StructureScannerItem.isPowered(stack) && entity.tickCount % 20 == 0) {
            StructureScannerItem.powerTick(stack, entity);
        }
    }

    private static void powerTick(ItemStack stack, Entity entity) {
        stack.set(MSItemComponents.POWER, (Object)(StructureScannerItem.getPower(stack) - 1));
        if (!StructureScannerItem.isPowered(stack)) {
            stack.set(MSItemComponents.TARGET_LOCATION, null);
            MutableComponent message = Component.translatable((String)OFF);
            entity.sendSystemMessage((Component)message.withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return StructureScannerItem.isPowered(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)StructureScannerItem.getPower(stack) / (float)this.powerCapacity);
    }

    public int getBarColor(ItemStack stack) {
        return 6732543;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }
}

