/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.armor;

import com.mraof.minestuck.client.model.armor.IronLassArmorModel;
import com.mraof.minestuck.util.MSParticleType;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

@ParametersAreNonnullByDefault
public class IronLassArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public IronLassArmorItem(Holder<ArmorMaterial> mat, ArmorItem.Type slot, Item.Properties props) {
        super(mat, slot, props);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof IronLassArmorItem && player.isShiftKeyDown()) {
                Vec3 look = player.getLookAngle();
                Vec3 movement = player.getDeltaMovement();
                player.level().playSound(player, player.blockPosition(), MSSoundEvents.ITEM_JETPACK_FLIGHT.get(), SoundSource.PLAYERS, 1.0f, player.getRandom().nextFloat() + 0.35f);
                player.level().addParticle((ParticleOptions)MSParticleType.EXHAUST.get(), player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0);
                player.level().addParticle((ParticleOptions)MSParticleType.EXHAUST.get(), player.getX() - movement.x / 2.0, player.getY() - movement.y / 2.0, player.getZ() - movement.z / 2.0, 0.0, 0.0, 0.0);
                player.setDeltaMovement(movement.add(look.x * 0.1 + (look.x * 1.5 - movement.x) * 0.2, look.y * 0.1 + (look.y * 1.5 - movement.y) * 0.2, look.z * 0.1 + (look.z * 1.5 - movement.z) * 0.2));
            }
            if (!player.level().isClientSide) {
                ItemStack feet;
                if ((player.getFallFlyingTicks() + 1) % 20 == 0) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.CHEST);
                }
                if ((feet = player.getItemBySlot(EquipmentSlot.FEET)).getItem() instanceof IronLassArmorItem && player.isShiftKeyDown() && (player.getFallFlyingTicks() + 1) % 5 == 0) {
                    feet.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.FEET);
                }
            }
        }
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "Fly/Idle", 3, state -> {
            LivingEntity livingEntity;
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) {
                return state.setAndContinue(DefaultAnimations.FLY);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private GeoArmorRenderer<?> renderer;

            @Nullable
            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new GeoArmorRenderer((GeoModel)new IronLassArmorModel());
                }
                return this.renderer;
            }
        });
    }
}

