/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.block;

import com.mraof.minestuck.block.machine.CruxtruderMultiblock;
import com.mraof.minestuck.blockentity.machine.CruxtruderBlockEntity;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.item.block.MultiblockItem;
import com.mraof.minestuck.util.ColorHandler;
import com.mraof.minestuck.util.MSRotationUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class CruxtruderItem
extends MultiblockItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CruxtruderMultiblock multiblock;

    public CruxtruderItem(CruxtruderMultiblock multiblock, Item.Properties properties) {
        super(multiblock, properties);
        this.multiblock = multiblock;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        if (player == null || level.isClientSide) {
            return false;
        }
        BlockEntity be = level.getBlockEntity(this.multiblock.getBEPos(pos, MSRotationUtil.fromDirection(player.getDirection().getOpposite())));
        if (be instanceof CruxtruderBlockEntity) {
            EditData editData = ServerEditHandler.getData(player);
            int color = editData != null ? ColorHandler.getColorForPlayer(editData.getTarget(), level) : ColorHandler.getColorForPlayer((ServerPlayer)player);
            ((CruxtruderBlockEntity)be).setColor(color);
            return true;
        }
        LOGGER.warn("Placed cruxtruder, but can't find block entity. Instead found {}.", (Object)be);
        return false;
    }
}

