/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.block;

import com.mraof.minestuck.block.CruxiteDowelBlock;
import com.mraof.minestuck.blockentity.ItemStackBlockEntity;
import com.mraof.minestuck.item.AlchemizedColored;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DowelItem
extends BlockItem
implements AlchemizedColored {
    public DowelItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public int getMaxStackSize(ItemStack stack) {
        if (stack.has(MSItemComponents.ENCODED_ITEM)) {
            return 16;
        }
        return 64;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        EncodedItemComponent encodedItemComponent = (EncodedItemComponent)stack.get(MSItemComponents.ENCODED_ITEM);
        if (encodedItemComponent != null) {
            ItemStack containedStack = encodedItemComponent.asItemStack();
            if (!containedStack.isEmpty()) {
                tooltip.add((Component)Component.literal((String)"(").append(containedStack.getHoverName()).append(")").withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.literal((String)"(").append((Component)Component.translatable((String)(this.getDescriptionId() + ".invalid"))).append(")").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState state = super.getPlacementState(context);
        if (state == null) {
            return null;
        }
        ItemStack stack = context.getItemInHand();
        state = stack.has(MSItemComponents.ENCODED_ITEM) ? (BlockState)state.setValue(CruxiteDowelBlock.DOWEL_TYPE, (Comparable)((Object)CruxiteDowelBlock.Type.TOTEM)) : (BlockState)state.setValue(CruxiteDowelBlock.DOWEL_TYPE, (Comparable)((Object)CruxiteDowelBlock.Type.DOWEL));
        return state;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof ItemStackBlockEntity) {
            ItemStack newStack = stack.copy();
            newStack.setCount(1);
            ((ItemStackBlockEntity)be).setStack(newStack);
        }
        return true;
    }
}

