/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.block;

import com.mraof.minestuck.block.machine.MachineMultiblock;
import com.mraof.minestuck.util.MSRotationUtil;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class MultiblockItem
extends BlockItem {
    private final MachineMultiblock multiblock;

    public MultiblockItem(MachineMultiblock multiblock, Item.Properties properties) {
        super(multiblock.getMainBlock(), properties);
        this.multiblock = multiblock;
    }

    public MachineMultiblock getMultiblock() {
        return this.multiblock;
    }

    public void registerBlocks(Map<Block, Item> blockToItemMap, Item itemIn) {
        this.multiblock.forEachBlock(block -> blockToItemMap.put((Block)block, itemIn));
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        this.multiblock.forEachBlock(block -> blockToItemMap.remove(block));
    }

    public InteractionResult place(BlockPlaceContext context) {
        Level level = context.getLevel();
        Direction sideFace = context.getClickedFace();
        if (sideFace != Direction.UP) {
            return InteractionResult.FAIL;
        }
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockPos pos = this.getPlacementPos(context);
        BlockPos clickedPos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (!this.canPlaceAt(context, pos, facing)) {
            return InteractionResult.FAIL;
        }
        BlockState state = this.getBlock().defaultBlockState();
        this.placeBlock(context, state);
        this.updateCustomBlockEntityTag(pos, level, player, stack, state);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, clickedPos, stack);
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, clickedPos);
        SoundType soundtype = state.getSoundType((LevelReader)level, clickedPos, (Entity)context.getPlayer());
        level.playSound(player, clickedPos, this.getPlaceSound(state, level, clickedPos, player), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        if (player == null || !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean canPlaceAt(BlockPlaceContext context, BlockPos pos, Direction facing) {
        Player player = context.getPlayer();
        if (player != null && !player.mayUseItemAt(pos, Direction.UP, context.getItemInHand())) {
            return false;
        }
        BoundingBox boundingBox = this.multiblock.getBoundingBox(MSRotationUtil.fromDirection(facing));
        for (int x = boundingBox.minX(); x <= boundingBox.maxX(); ++x) {
            for (int z = boundingBox.minZ(); z <= boundingBox.maxZ(); ++z) {
                for (int y = boundingBox.minY(); y <= boundingBox.maxY(); ++y) {
                    if (!context.getLevel().isOutsideBuildHeight(pos.offset(x, y, z)) && (player == null || context.getLevel().mayInteract(player, pos)) && context.getLevel().getBlockState(pos.offset(x, y, z)).canBeReplaced(context)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState newState) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            BlockPos pos = this.getPlacementPos(context);
            MachineMultiblock.Placement placement = new MachineMultiblock.Placement(pos, MSRotationUtil.fromDirection(context.getHorizontalDirection().getOpposite()));
            this.multiblock.placeWithRotation((LevelAccessor)level, placement);
            this.multiblock.placeAdditional(level, placement);
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(player2, pos, context.getItemInHand());
            }
        }
        return true;
    }

    private BlockPos getPlacementPos(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        if (!context.getLevel().getBlockState(pos).canBeReplaced(context)) {
            pos = pos.above();
        }
        Direction facing = context.getHorizontalDirection().getOpposite();
        return this.getPlacementPos(pos, facing, context.getClickLocation().x - (double)pos.getX(), context.getClickLocation().z - (double)pos.getZ());
    }

    public BlockPos getPlacementPos(BlockPos pos, Direction direction, double hitX, double hitZ) {
        BoundingBox bb = this.multiblock.getBoundingBox(MSRotationUtil.fromDirection(direction));
        if (direction.getAxis() == Direction.Axis.X) {
            return pos.south((int)Math.floor(hitZ - (double)((bb.maxZ() - bb.minZ()) * direction.getClockWise().getStepZ()) / 2.0));
        }
        if (direction.getAxis() == Direction.Axis.Z) {
            return pos.east((int)Math.floor(hitX - (double)((bb.maxX() - bb.minX()) * direction.getClockWise().getStepX()) / 2.0));
        }
        throw new IllegalArgumentException("Direction should be horizontal");
    }
}

