/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.block;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.util.MSDamageSources;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

@ParametersAreNonnullByDefault
public class SendificatorBlockItem
extends BlockItem {
    public SendificatorBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemStackIn = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown() && playerIn.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            playerIn.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)MSBlocks.SENDIFICATOR.get()));
            return InteractionResultHolder.success((Object)new ItemStack((ItemLike)Blocks.AIR));
        }
        return InteractionResultHolder.pass((Object)itemStackIn);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        Player playerIn;
        ItemStack recoverItem;
        if (entityIn instanceof Player && (recoverItem = (playerIn = (Player)entityIn).getItemBySlot(EquipmentSlot.HEAD)).is((Item)MSItems.SENDIFICATOR.get()) && !playerIn.isCreative()) {
            ItemStack headItem = new ItemStack((ItemLike)Items.PLAYER_HEAD, 1);
            headItem.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerIn.getGameProfile()));
            ItemEntity headItemEntity = new ItemEntity(level, playerIn.getX(), playerIn.getY(), playerIn.getZ(), headItem);
            level.addFreshEntity((Entity)headItemEntity);
            ItemEntity recoverItemEntity = new ItemEntity(level, playerIn.getX(), playerIn.getY(), playerIn.getZ(), recoverItem);
            level.addFreshEntity((Entity)recoverItemEntity);
            playerIn.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.AIR));
            playerIn.hurt(MSDamageSources.decapitation(level.registryAccess()), Float.MAX_VALUE);
        }
        super.inventoryTick(stack, level, entityIn, itemSlot, isSelected);
    }
}

