/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.block;

import com.mraof.minestuck.block.StoneTabletBlock;
import com.mraof.minestuck.blockentity.ItemStackBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.StoneTabletTextComponent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StoneTabletItem
extends BlockItem {
    public StoneTabletItem(Block blockIn, Item.Properties properties) {
        super(blockIn, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (StoneTabletTextComponent.hasText(stack)) {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".carved")).withStyle(ChatFormatting.GRAY));
        }
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState state = super.getPlacementState(context);
        if (state == null) {
            return null;
        }
        ItemStack stack = context.getItemInHand();
        state = (BlockState)((BlockState)state.setValue((Property)StoneTabletBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)StoneTabletBlock.CARVED, (Comparable)Boolean.valueOf(StoneTabletTextComponent.hasText(stack)));
        return state;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ItemStackBlockEntity) {
            ItemStackBlockEntity blockEntity2 = (ItemStackBlockEntity)blockEntity;
            ItemStack newStack = stack.copy();
            newStack.setCount(1);
            blockEntity2.setStack(newStack);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemStackIn = playerIn.getItemInHand(handIn);
        if (!playerIn.isShiftKeyDown()) {
            if (level.isClientSide) {
                boolean canEdit = playerIn.getItemInHand(handIn == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND).getItem() == MSItems.CARVING_TOOL.get();
                String text = StoneTabletTextComponent.getText(itemStackIn);
                MSScreenFactories.displayStoneTabletScreen(playerIn, handIn, text, canEdit);
            }
            return InteractionResultHolder.success((Object)itemStackIn);
        }
        return super.use(level, playerIn, handIn);
    }

    public InteractionResult place(BlockPlaceContext context) {
        Player playerIn = context.getPlayer();
        if (playerIn == null || playerIn.isShiftKeyDown()) {
            return super.place(context);
        }
        return InteractionResult.PASS;
    }
}

