/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.item.components.MSItemComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class TransportalizerItem
extends BlockItem {
    public TransportalizerItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        TransportalizerData data = (TransportalizerData)stack.get(MSItemComponents.TRANSPORTALIZER_DATA);
        if (data == null) {
            return;
        }
        if (data.locked()) {
            tooltip.add((Component)Component.translatable((String)"block.minestuck.transportalizer.locked_message").withStyle(ChatFormatting.GRAY));
        } else {
            data.id().ifPresent(id -> tooltip.add((Component)Component.translatable((String)"block.minestuck.transportalizer.idString", (Object[])new Object[]{id}).withStyle(ChatFormatting.GRAY)));
            data.destinationId().ifPresent(destId -> tooltip.add((Component)Component.translatable((String)"block.minestuck.transportalizer.destId", (Object[])new Object[]{destId}).withStyle(ChatFormatting.GRAY)));
        }
    }

    public record TransportalizerData(Optional<String> id, Optional<String> destinationId, boolean locked) {
        public static final Codec<TransportalizerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("id").forGetter(TransportalizerData::id), (App)Codec.STRING.optionalFieldOf("destination_id").forGetter(TransportalizerData::destinationId), (App)Codec.BOOL.fieldOf("locked").forGetter(TransportalizerData::locked)).apply((Applicative)instance, TransportalizerData::new));
        public static final StreamCodec<FriendlyByteBuf, TransportalizerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), TransportalizerData::id, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), TransportalizerData::destinationId, (StreamCodec)ByteBufCodecs.BOOL, TransportalizerData::locked, TransportalizerData::new);
    }
}

