/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.components;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.alchemy.CardCaptchas;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record CaptchaCodeComponent(String code, boolean hasRefreshed) {
    public static final Codec<CaptchaCodeComponent> CODEC = Codec.STRING.xmap(code -> new CaptchaCodeComponent((String)code, false), CaptchaCodeComponent::code);
    public static final StreamCodec<ByteBuf, CaptchaCodeComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CaptchaCodeComponent::code, code -> new CaptchaCodeComponent((String)code, false));
    public static final CaptchaCodeComponent ZERO = new CaptchaCodeComponent("00000000", false);

    public static CaptchaCodeComponent createFor(ItemStack itemStack, MinecraftServer mcServer) {
        return CaptchaCodeComponent.createFor(itemStack.getItem(), mcServer);
    }

    public static CaptchaCodeComponent createFor(Item item, MinecraftServer mcServer) {
        return new CaptchaCodeComponent(CardCaptchas.getCaptcha(item, mcServer), true);
    }
}

